/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.imageloader.factory;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.kangxin.common.imageloader.GlideApp;
import com.kangxin.common.imageloader.GlideRequest;
import com.kangxin.common.imageloader.ImageLoader;

public class GlideImageLoader
implements ImageLoader {
    RequestBuilder load;
    private Context mContext;

    public GlideImageLoader(Context mContext) {
        this.mContext = mContext;
    }

    @Override
    public ImageLoader loadImage(String url) {
        this.load = GlideApp.with(this.mContext).load(url);
        return this;
    }

    @Override
    public ImageLoader bitmapTransform(int style2) {
        RequestOptions options = new RequestOptions();
        switch (style2) {
            case 1: {
                options.dontTransform();
                break;
            }
            case 2: {
                options.circleCrop();
            }
        }
        this.load.apply((BaseRequestOptions)options);
        return this;
    }

    @Override
    public ImageLoader bitmapTransform(Transformation<Bitmap> transformation) {
        RequestOptions options = new RequestOptions();
        options.transform(transformation);
        this.load.apply((BaseRequestOptions)options);
        return this;
    }

    @Override
    public ImageLoader placeholder(int id2) {
        if (this.load instanceof GlideRequest) {
            ((GlideRequest)this.load).placeholder(id2);
        }
        return this;
    }

    @Override
    public ImageLoader transform(Transformation<Bitmap> transformation) {
        if (this.load instanceof GlideRequest) {
            ((GlideRequest)this.load).transform(transformation);
        }
        return this;
    }

    @Override
    public ImageLoader centerCrop() {
        if (this.load instanceof GlideRequest) {
            ((GlideRequest)this.load).centerCrop();
        }
        return this;
    }

    @Override
    public ImageLoader placeholder(Drawable drawable2) {
        if (this.load instanceof GlideRequest) {
            ((GlideRequest)this.load).placeholder(drawable2);
        }
        return this;
    }

    @Override
    public void into(ImageView target) {
        this.load.into(target);
    }

    @Override
    public ImageLoader err(int id2) {
        if (this.load instanceof GlideRequest) {
            ((GlideRequest)this.load).error(id2);
        }
        return this;
    }

    @Override
    public ImageLoader err(Drawable drawable2) {
        if (this.load instanceof GlideRequest) {
            ((GlideRequest)this.load).error(drawable2);
        }
        return this;
    }

    @Override
    public ImageLoader diskCacheStrategy(DiskCacheStrategy diskCacheStrategy) {
        if (this.load instanceof GlideRequest) {
            ((GlideRequest)this.load).diskCacheStrategy(diskCacheStrategy);
        }
        return this;
    }

    @Override
    public ImageLoader skipMemoryCache(boolean isCache) {
        if (this.load instanceof GlideRequest) {
            ((GlideRequest)this.load).skipMemoryCache(isCache);
        }
        return this;
    }

    @Override
    public ImageLoader sign(Key key) {
        if (this.load instanceof GlideRequest) {
            ((GlideRequest)this.load).signature(key);
        }
        return this;
    }
}

