/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.util;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.IdRes;
import androidx.recyclerview.widget.RecyclerView;
import com.chad.library.adapter.base.BaseQuickAdapter;

public class ListViewUtil {
    public static void setRecyclerViewHeight(RecyclerView recyclerView, @IdRes int itemViewId, int itemLimiteCount) {
        RecyclerView.Adapter recyclerAdapter = recyclerView.getAdapter();
        if (recyclerAdapter == null) {
            return;
        }
        if (recyclerAdapter instanceof BaseQuickAdapter) {
            int totalHeight = 0;
            int len = recyclerAdapter.getItemCount();
            for (int i = 0; i < len && i < itemLimiteCount; ++i) {
                View itemView = ((BaseQuickAdapter)recyclerAdapter).getViewByPosition(i, itemViewId);
                itemView.measure(0, 0);
                totalHeight += itemView.getMeasuredHeight();
            }
            ViewGroup.LayoutParams params = recyclerView.getLayoutParams();
            params.height = totalHeight + (recyclerAdapter.getItemCount() - 1);
            recyclerView.setLayoutParams(params);
        }
    }

    public static void setListViewHeightBasedOnChildren(ListView listView, int itemLimiteCount) {
        ListAdapter listAdapter = listView.getAdapter();
        if (listAdapter == null) {
            return;
        }
        int totalHeight = 0;
        int len = listAdapter.getCount();
        for (int i = 0; i < len && i < itemLimiteCount; ++i) {
            View listItem = listAdapter.getView(i, null, (ViewGroup)listView);
            listItem.measure(0, 0);
            totalHeight += listItem.getMeasuredHeight();
        }
        ViewGroup.LayoutParams params = listView.getLayoutParams();
        params.height = totalHeight + listView.getDividerHeight() * (listAdapter.getCount() - 1);
        listView.setLayoutParams(params);
    }
}

