/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.util;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.text.TextUtils;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static String changeSubText(String txt, int subLength) {
        StringBuilder stringBuilder = new StringBuilder();
        String subTxt = null;
        if (!TextUtils.isEmpty((CharSequence)txt)) {
            if (txt.length() > subLength) {
                subTxt = txt.substring(0, subLength - 1);
                stringBuilder.append(subTxt);
                subTxt = stringBuilder.append("...").toString();
            } else {
                subTxt = txt;
            }
        }
        return subTxt;
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static int idToAge(String IdNO) {
        IdNO = IdNO.trim();
        int leh = IdNO.length();
        String dates = "";
        if (leh == 18) {
            dates = IdNO.substring(6, 10);
            SimpleDateFormat df = new SimpleDateFormat("yyyy");
            String year = df.format(new Date());
            int u = Integer.parseInt(year) - Integer.parseInt(dates);
            return u;
        }
        if (leh == 15) {
            dates = IdNO.substring(6, 8);
            return Integer.parseInt(dates);
        }
        return 0;
    }

    public static String formatTime(long ms) {
        int ss = 1000;
        int mi = ss * 60;
        int hh = mi * 60;
        int dd = hh * 24;
        long day = ms / (long)dd;
        long hour = (ms - day * (long)dd) / (long)hh;
        long minute = (ms - day * (long)dd - hour * (long)hh) / (long)mi;
        long second = (ms - day * (long)dd - hour * (long)hh - minute * (long)mi) / (long)ss;
        long milliSecond = ms - day * (long)dd - hour * (long)hh - minute * (long)mi - second * (long)ss;
        String strDay = day < 10L ? "0" + day : "" + day;
        String strHour = hour < 10L ? "0" + hour : "" + hour;
        String strMinute = minute < 10L ? "0" + minute : "" + minute;
        String strSecond = second < 10L ? "0" + second : "" + second;
        String strMilliSecond = milliSecond < 10L ? "0" + milliSecond : "" + milliSecond;
        strMilliSecond = milliSecond < 100L ? "0" + strMilliSecond : "" + strMilliSecond;
        return strDay + StringsUtils.getString(R.string.common_tian_) + strHour + StringsUtils.getString(R.string.common_xiaoshi_) + strMinute + StringsUtils.getString(R.string.common_fen_) + strSecond + StringsUtils.getString(R.string.common_miao);
    }

    public static void formatTime(long ms, OnTimeCallback onTimeCallback) {
        int ss = 1000;
        int mi = ss * 60;
        int hh = mi * 60;
        int dd = hh * 24;
        long day = ms / (long)dd;
        long hour = (ms - day * (long)dd) / (long)hh;
        long minute = (ms - day * (long)dd - hour * (long)hh) / (long)mi;
        long second = (ms - day * (long)dd - hour * (long)hh - minute * (long)mi) / (long)ss;
        long milliSecond = ms - day * (long)dd - hour * (long)hh - minute * (long)mi - second * (long)ss;
        String strDay = day < 10L ? "0" + day : "" + day;
        String strHour = hour < 10L ? "0" + hour : "" + hour;
        String strMinute = minute < 10L ? "0" + minute : "" + minute;
        String strSecond = second < 10L ? "0" + second : "" + second;
        String strMilliSecond = milliSecond < 10L ? "0" + milliSecond : "" + milliSecond;
        String string2 = strMilliSecond = milliSecond < 100L ? "0" + strMilliSecond : "" + strMilliSecond;
        if (onTimeCallback != null) {
            onTimeCallback.onTime(strDay, strHour, strMinute, strSecond);
        }
    }

    public static boolean copy(Context context, String copyStr) {
        try {
            ClipboardManager cm = (ClipboardManager)context.getSystemService("clipboard");
            ClipData mClipData = ClipData.newPlainText((CharSequence)"Label", (CharSequence)copyStr);
            cm.setPrimaryClip(mClipData);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static interface OnTimeCallback {
        public void onTime(String var1, String var2, String var3, String var4);
    }
}

