/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.widget;

import android.accounts.NetworkErrorException;
import android.text.TextUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.google.gson.JsonParseException;
import com.kangxin.common.R;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.util.StringsUtils;
import io.reactivex.observers.DefaultObserver;
import java.net.UnknownHostException;
import retrofit2.HttpException;

public abstract class RxBaseObserver<T>
extends DefaultObserver<T> {
    public void onNext(T t) {
        ResponseBody responseBody;
        if (t instanceof ResponseBody && (responseBody = (ResponseBody)t).getCode() != 200) {
            this.onReqErr(responseBody.getCode(), responseBody.getMsg(), responseBody.getErrCode());
            return;
        }
        if (t instanceof UnknownHostException) {
            ToastUtils.showShort((CharSequence)StringsUtils.getString(R.string.common_qingjianchawangluolianjieshifoukeyong));
            return;
        }
        if (t instanceof NetworkErrorException || t instanceof HttpException) {
            ToastUtils.showShort((CharSequence)StringsUtils.getString(R.string.common_wangluofangwencuowu));
            return;
        }
        if (t instanceof JsonParseException) {
            return;
        }
        if (t instanceof NullPointerException) {
            ToastUtils.showShort((CharSequence)(t + ""));
            return;
        }
        if (t instanceof ArrayIndexOutOfBoundsException) {
            ToastUtils.showShort((CharSequence)(t + ""));
            return;
        }
        this.onReqNext(t);
    }

    public abstract void onReqNext(T var1);

    public void onReqErr(Throwable e) {
    }

    public void onReqErr(int code, String msg, String errCode) {
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            ToastUtils.showLong((CharSequence)msg);
        }
    }
}

