/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.util;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class DelayUtils {
    private static Map<Object, Build> timerMap = new HashMap<Object, Build>();
    private static CompositeDisposable compositeDisposable = new CompositeDisposable();

    private DelayUtils() {
    }

    public static void resetListener(Object key, Delay delay) {
        if (timerMap.get(key) == null) {
            return;
        }
        Objects.requireNonNull(DelayUtils.timerMap.get((Object)key)).listenerList.clear();
        Objects.requireNonNull(DelayUtils.timerMap.get((Object)key)).listenerList.add(delay);
    }

    public static void addListener(Object key, Delay delay) {
        if (timerMap.get(key) == null) {
            return;
        }
        Objects.requireNonNull(DelayUtils.timerMap.get((Object)key)).listenerList.add(delay);
    }

    public static void updateTime(Object key, long allSecond, long extSecond) {
        Build build2 = timerMap.get(key);
        if (build2 == null) {
            return;
        }
        if (allSecond != -1L) {
            build2.allSecond = allSecond;
        }
        if (extSecond != -1L) {
            build2.exeSecond = extSecond;
        }
    }

    public static long getTaskExeTime(Object key) {
        Build build2 = timerMap.get(key);
        if (build2 == null) {
            return -1L;
        }
        return build2.exeSecond;
    }

    public static long getTaskAllTime(Object key) {
        Build build2 = timerMap.get(key);
        if (build2 == null) {
            return -1L;
        }
        return build2.allSecond;
    }

    public static boolean hasRunningTask(Object key) {
        return timerMap.get(key) != null;
    }

    public static Build creatFactory(Object key) {
        if (timerMap.get(key) != null) {
            DelayUtils.remove(key);
        }
        return new Build(key);
    }

    public static void remove(Object key) {
        if (timerMap.get(key) == null) {
            return;
        }
        compositeDisposable.remove(Objects.requireNonNull(DelayUtils.timerMap.get((Object)key)).disposable);
        timerMap.remove(key);
    }

    public static void removeListener(Object key, Delay delay) {
        if (timerMap.get(key) == null) {
            return;
        }
        Objects.requireNonNull(DelayUtils.timerMap.get((Object)key)).listenerList.remove(delay);
    }

    public static void clear() {
        timerMap.clear();
        compositeDisposable.clear();
    }

    public static class Build {
        Object key;
        long exeSecond = 0L;
        long allSecond = 0L;
        long signSecond = 0L;
        Disposable disposable;
        List<Delay> listenerList = new ArrayList<Delay>();

        private Build(Object key) {
            this.key = key;
        }

        public Build bindTaskTime(long second) {
            this.allSecond = second;
            return this;
        }

        public Build bindSignTime(long sign) {
            this.signSecond = sign;
            return this;
        }

        public Build bindListener(Delay delay) {
            this.listenerList.add(delay);
            return this;
        }

        public void start() {
            timerMap.put(this.key, this);
            Observable.interval((long)0L, (long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<Long>(){

                public void onSubscribe(Disposable d) {
                    compositeDisposable.add(d);
                    disposable = d;
                }

                public void onNext(Long aLong) {
                    if (exeSecond <= allSecond) {
                        if (listenerList.size() == 0) {
                            return;
                        }
                        ++exeSecond;
                        for (Delay item : listenerList) {
                            item.delay(allSecond, exeSecond, signSecond);
                        }
                    } else {
                        disposable.dispose();
                    }
                }

                public void onError(Throwable e) {
                    this.start();
                }

                public void onComplete() {
                }
            });
        }
    }

    public static interface Delay {
        public void delay(long var1, long var3, long var5);
    }
}

