/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.util;

import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtil {
    public static final String FORMAT_TIME = "HH:mm";
    public static final String FORMAT_DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_DATE_TIME_SECOND = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_MONTH_DAY_TIME = "MM-dd HH:mm";
    public static final String FORMAT_DATE = "yyyy-MM-dd";

    public static String getFormatToday(String dateFormat) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        return formatter.format(currentTime);
    }

    public static String getFormatTime(Long time, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(time);
    }

    public static Date stringToDate(String dateStr, String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        try {
            return formatter.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String dateToString(Date date, String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        return formatter.format(date);
    }

    public static String getChatTime(boolean hasYear, long timesamp) {
        String result;
        long clearTime = timesamp;
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        Date today = new Date(System.currentTimeMillis());
        Date otherDay = new Date(clearTime);
        int temp = Integer.parseInt(sdf.format(today)) - Integer.parseInt(sdf.format(otherDay));
        switch (temp) {
            case 0: {
                result = StringsUtils.getString(R.string.worktab_jintian_) + TimeUtil.getHourAndMin(clearTime);
                break;
            }
            case 1: {
                result = StringsUtils.getString(R.string.worktab_zuotian_) + TimeUtil.getHourAndMin(clearTime);
                break;
            }
            case 2: {
                result = StringsUtils.getString(R.string.worktab_qiantian_) + TimeUtil.getHourAndMin(clearTime);
                break;
            }
            default: {
                result = TimeUtil.getTime(hasYear, clearTime);
            }
        }
        return result;
    }

    public static String getTime(boolean hasYear, long time) {
        String pattern = "yyyy-MM-dd HH:mm:ss";
        if (!hasYear) {
            pattern = FORMAT_MONTH_DAY_TIME;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(new Date(time));
    }

    private static String getHourAndMin(long time) {
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_TIME);
        return format.format(new Date(time));
    }

    public static String getWeekOfDate(Date date) {
        String[] weekDays = new String[]{StringsUtils.getString(R.string.worktab_xingqiri), StringsUtils.getString(R.string.worktab_xingqiyi), StringsUtils.getString(R.string.worktab_xingqier), StringsUtils.getString(R.string.worktab_xingqisan), StringsUtils.getString(R.string.worktab_xingqisi), StringsUtils.getString(R.string.worktab_xingqiwu), StringsUtils.getString(R.string.worktab_xingqiliu)};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static String utc2Local(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'X'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateUtcTime = sdf.format(date);
        Date utcDate = null;
        try {
            utcDate = sdf.parse(dateUtcTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        sdf.setTimeZone(TimeZone.getDefault());
        Date localDate = null;
        String localTime = sdf.format(utcDate.getTime());
        try {
            localDate = sdf.parse(localTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return sdf1.format(localDate);
    }

    public static String utc2Local2(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'X'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateUtcTime = sdf.format(date);
        Date utcDate = null;
        try {
            utcDate = sdf.parse(dateUtcTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        sdf.setTimeZone(TimeZone.getDefault());
        Date localDate = null;
        String localTime = sdf.format(utcDate.getTime());
        try {
            localDate = sdf.parse(localTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        SimpleDateFormat sdf1 = new SimpleDateFormat(StringsUtils.getString(R.string.worktab_yyyynianmmyueddri_hh_mm));
        return sdf1.format(localDate);
    }

    public static String date2Timestamp(String date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            return String.valueOf(sdf.parse(date).getTime());
        }
        catch (ParseException e) {
            return "";
        }
    }

    public static String timeStamp2Date(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(time));
    }

    public static long stringToLong(String strTime, String formatType) {
        Date date = TimeUtil.stringToDate(strTime, formatType);
        if (date == null) {
            return 0L;
        }
        long currentTime = date.getTime();
        return currentTime;
    }

    public static String dateToStamp(String date) {
        SimpleDateFormat sf1 = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sf2 = new SimpleDateFormat(StringsUtils.getString(R.string.worktab_yyyynianmmyue));
        String sfStr = "";
        try {
            sfStr = sf2.format(sf1.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return sfStr;
    }

    public static String getFixString(long millis1, long millis2, int precision) {
        long millis = millis1 - millis2;
        if (precision <= 0) {
            return null;
        }
        int newPre = Math.min(precision, 5);
        String[] units = new String[]{":", ":", ":", ":", ":"};
        if (millis == 0L) {
            return 0 + units[newPre - 1];
        }
        StringBuilder sb = new StringBuilder();
        if (millis < 0L) {
            sb.append("-");
            millis = -millis;
        }
        int[] unitLen = new int[]{86400000, 3600000, 60000, 1000, 1};
        for (int i = 0; i < newPre; ++i) {
            if (millis < (long)unitLen[i]) continue;
            long mode = millis / (long)unitLen[i];
            millis -= mode * (long)unitLen[i];
            sb.append(mode).append(units[i]);
        }
        return sb.toString();
    }
}

