/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.appcompat.widget.SwitchCompat;
import com.kangxin.common.R;

public class PractisManagerItem
extends RelativeLayout {
    private Context mContext;
    private View mValueLayoutView;
    private TextView mValueNameView;
    private SwitchCompat mSwitchView;
    private TextView mLabelNameView;
    private ImageView mRightArrowView;
    private ItemType mItemType;

    public PractisManagerItem(Context context) {
        this(context, null);
    }

    public PractisManagerItem(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PractisManagerItem(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        LayoutInflater.from((Context)context).inflate(R.layout.worktab_practis_manager_item, (ViewGroup)this);
        this.mValueLayoutView = this.findViewById(R.id.value_layout);
        this.mValueNameView = (TextView)this.findViewById(R.id.value_name);
        this.mSwitchView = (SwitchCompat)this.findViewById(R.id.switch_btn);
        this.mLabelNameView = (TextView)this.findViewById(R.id.label_name_txt);
        this.mRightArrowView = (ImageView)this.findViewById(R.id.right_arrow_img);
    }

    public SwitchCompat getSwitchCompatView() {
        return this.mSwitchView;
    }

    public void setLabelName(String labelName) {
        this.mLabelNameView.setText((CharSequence)labelName);
    }

    public void showItemType(ItemType itemType) {
        this.mItemType = itemType;
        switch (itemType) {
            case NORMAL: {
                this.mSwitchView.setVisibility(8);
                this.mValueLayoutView.setVisibility(0);
                this.mValueNameView.setVisibility(8);
                this.mRightArrowView.setVisibility(0);
                break;
            }
            case LABEL: {
                this.mSwitchView.setVisibility(8);
                this.mValueLayoutView.setVisibility(0);
                this.mValueNameView.setVisibility(0);
                this.mRightArrowView.setVisibility(0);
                break;
            }
            case NOOPEN: {
                this.mSwitchView.setVisibility(8);
                this.mValueLayoutView.setVisibility(0);
                this.mRightArrowView.setVisibility(8);
                this.mValueNameView.setVisibility(0);
                break;
            }
            case SWITCH: {
                this.mValueLayoutView.setVisibility(8);
                this.mSwitchView.setVisibility(0);
            }
        }
    }

    public void setValueNameColor(@ColorInt int color2) {
        this.mValueNameView.setTextColor(color2);
    }

    public void setValueName(String valueName) {
        this.mValueNameView.setText((CharSequence)valueName);
    }

    public static enum ItemType {
        NORMAL,
        LABEL,
        NOOPEN,
        SWITCH;

    }
}

