package com.byh.module.onlineoutser.im.utils;

import com.blankj.utilcode.util.StringUtils;
import com.kangxin.common.R;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

/**
 * Created by poetr on 17/11/9.
 */

public class DateUtils {
    public static final TimeZone tz = TimeZone.getTimeZone("GMT+8:00");
    public static final SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final int SHOW_TYPE_SIMPLE = 0;
    public static final int SHOW_TYPE_COMPLEX = 1;
    public static final int SHOW_TYPE_ALL = 2;
    public static final int SHOW_TYPE_CALL_LOG = 3;
    public static final int SHOW_TYPE_CALL_DETAIL = 4;
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final long ONEDAY = 86400000;

    /**
     * 获取当前当天日期的毫秒数 2012-03-21的毫秒数
     *
     * @return
     */
    public static long getCurrentDayTime() {
        Date d = new Date(System.currentTimeMillis());
        String formatDate = yearFormat.format(d);
        try {
            return (yearFormat.parse(formatDate)).getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static String getDateString(long time) {
        Calendar c = Calendar.getInstance(tz);
        c.setTimeInMillis(time);
        long currentTime = System.currentTimeMillis();
        Calendar current_c = Calendar.getInstance(tz);
        current_c.setTimeInMillis(currentTime);
        int y = c.get(Calendar.YEAR);
        int m = c.get(Calendar.MONTH) + 1;
        int d = c.get(Calendar.DAY_OF_MONTH);
        int hour = c.get(Calendar.HOUR_OF_DAY);
        int minute = c.get(Calendar.MINUTE);
        int second = c.get(Calendar.SECOND);
        long t = currentTime - time;
        long t2 = currentTime - getCurrentDayTime();
        String dateStr = "";
        if (t < t2 && t > 0) {
            dateStr = (hour < 10 ? "0" + hour : hour) + ":"
                    + (minute < 10 ? "0" + minute : minute) + ":"
                    + (second < 10 ? "0" + second : second);
        } else if (t < (t2 + ONEDAY) && t > 0) {
            dateStr = StringUtils.getString(R.string.onlineoutser_zuotian) + (hour < 10 ? "0" + hour : hour) + ":"
                    + (minute < 10 ? "0" + minute : minute) + ":"
                    + (second < 10 ? "0" + second : second);
        } else {
            dateStr = y % 100 + "." + (m < 10 ? "0" + m : m) + "."
                    + (d < 10 ? "0" + d : d) + " "
                    + (hour < 10 ? "0" + hour : hour) + ":"
                    + (minute < 10 ? "0" + minute : minute) + ":"
                    + (second < 10 ? "0" + second : second);
        }
        return dateStr;
    }

    public static String getDefDateString(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        long currentTime = System.currentTimeMillis();
        Calendar current_c = Calendar.getInstance();
        current_c.setTimeInMillis(currentTime);
        int y = c.get(Calendar.YEAR);
        int m = c.get(Calendar.MONTH) + 1;
        int d = c.get(Calendar.DAY_OF_MONTH);
        int hour = c.get(Calendar.HOUR_OF_DAY);
        int minute = c.get(Calendar.MINUTE);
        int second = c.get(Calendar.SECOND);
        long t = currentTime - time;
        long t2 = currentTime - getCurrentDayTime();
        String dateStr = "";
        if (t < t2 && t > 0) {
            dateStr = (hour < 10 ? "0" + hour : hour) + ":"
                    + (minute < 10 ? "0" + minute : minute) + ":"
                    + (second < 10 ? "0" + second : second);
        } else if (t < (t2 + ONEDAY) && t > 0) {
            dateStr = StringUtils.getString(R.string.onlineoutser_zuotian) + (hour < 10 ? "0" + hour : hour) + ":"
                    + (minute < 10 ? "0" + minute : minute) + ":"
                    + (second < 10 ? "0" + second : second);
        } else {
            dateStr = y % 100 + "." + (m < 10 ? "0" + m : m) + "."
                    + (d < 10 ? "0" + d : d) + " "
                    + (hour < 10 ? "0" + hour : hour) + ":"
                    + (minute < 10 ? "0" + minute : minute) + ":"
                    + (second < 10 ? "0" + second : second);
        }
        return dateStr;
    }

    public static long dateToStamp(String s) {
        Date date = null;
        long stamp = 0;
        try {
            date = simpleDateFormat.parse(s);
            stamp = date.getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return stamp;
    }

}
