package com.byh.module.onlineoutser.im.view;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.animation.AlphaAnimation;

import androidx.appcompat.widget.AppCompatTextView;

import com.kangxin.common.R;


/**
 * 语音播放动画
 */
public class CCPAnimImageView extends AppCompatTextView {

    private static final int TYPE_VOICE_PLAYING = 1;


    private AlphaAnimation mAlphaAnimation;

    /**
     * chatting from animation
     */
    private AnimationDrawable mChattingFromAnimationDrawable;

    /**
     * chatting to animation
     */
    private AnimationDrawable mChattingToAnimationDrawable;

    /**
     *
     */
    private int mDuration = 300;

    private boolean isFrom = false;

    private boolean isRunning = false;

    /**
     * @param context
     */
    public CCPAnimImageView(Context context) {
        super(context);
        initCCPAnimImageView();
    }

    /**
     * @param context
     * @param attrs
     */
    public CCPAnimImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initCCPAnimImageView();
    }

    /**
     * @param context
     * @param attrs
     * @param defStyle
     */
    public CCPAnimImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        initCCPAnimImageView();
    }


    /**
     *
     */
    public void initCCPAnimImageView() {

        mAlphaAnimation = new AlphaAnimation(0.1F, 0.1F);
        mAlphaAnimation.setDuration(1000L);
        mAlphaAnimation.setRepeatCount(AlphaAnimation.INFINITE);
        mAlphaAnimation.setRepeatMode(AlphaAnimation.REVERSE);

        // chatting from animation
        mChattingFromAnimationDrawable = new AnimationDrawable();
        Drawable chattingFDrawale1 = getResources().getDrawable(R.drawable.online_chatfrom_voice_playing_f1);
        chattingFDrawale1.setBounds(0, 0, chattingFDrawale1.getIntrinsicWidth(), chattingFDrawale1.getIntrinsicHeight());
        mChattingFromAnimationDrawable.addFrame(chattingFDrawale1, mDuration);

        Drawable chattingFDrawale2 = getResources().getDrawable(R.drawable.online_chatfrom_voice_playing_f2);
        chattingFDrawale2.setBounds(0, 0, chattingFDrawale2.getIntrinsicWidth(), chattingFDrawale2.getIntrinsicHeight());
        mChattingFromAnimationDrawable.addFrame(chattingFDrawale2, mDuration);

        Drawable chattingFDrawale3 = getResources().getDrawable(R.drawable.online_chatfrom_voice_playing_f3);
        chattingFDrawale3.setBounds(0, 0, chattingFDrawale3.getIntrinsicWidth(), chattingFDrawale3.getIntrinsicHeight());
        mChattingFromAnimationDrawable.addFrame(chattingFDrawale3, mDuration);
        mChattingFromAnimationDrawable.setOneShot(false);
        mChattingFromAnimationDrawable.setVisible(true, true);


        // chatting to animation
        mChattingToAnimationDrawable = new AnimationDrawable();
        Drawable chattingTDrawable_1 = getResources().getDrawable(R.drawable.online_chatto_voice_playing_f1);
        chattingTDrawable_1.setBounds(0, 0, chattingTDrawable_1.getIntrinsicWidth(), chattingTDrawable_1.getIntrinsicHeight());
        mChattingToAnimationDrawable.addFrame(chattingTDrawable_1, mDuration);

        Drawable chattingTDrawable_2 = getResources().getDrawable(R.drawable.online_chatto_voice_playing_f2);
        chattingTDrawable_2.setBounds(0, 0, chattingTDrawable_2.getIntrinsicWidth(), chattingTDrawable_2.getIntrinsicHeight());
        mChattingToAnimationDrawable.addFrame(chattingTDrawable_2, mDuration);

        Drawable chattingTDrawable_3 = getResources().getDrawable(R.drawable.online_chatto_voice_playing_f3);
        chattingTDrawable_3.setBounds(0, 0, chattingTDrawable_3.getIntrinsicWidth(), chattingTDrawable_3.getIntrinsicHeight());
        mChattingToAnimationDrawable.addFrame(chattingTDrawable_3, mDuration);
        mChattingToAnimationDrawable.setOneShot(false);
        mChattingToAnimationDrawable.setVisible(true, true);
        restBackground();
    }

    public void setDirection(boolean from) {
        isFrom = from;
        restBackground();
    }


    public final void startVoiceAnimation() {
        if (!isRunning) {
            isRunning = true;
            if (isFrom) {
                // start chatting from animation
                setCompoundDrawablesWithIntrinsicBounds(mChattingFromAnimationDrawable, null, null, null);
                mChattingFromAnimationDrawable.stop();
                mChattingFromAnimationDrawable.start();
                return;
            }

            // start chatting to animation
            setCompoundDrawablesWithIntrinsicBounds(null, null, mChattingToAnimationDrawable, null);
            mChattingToAnimationDrawable.stop();
            mChattingToAnimationDrawable.start();
        }
    }

    /**
     *
     */
    public final void restBackground() {
        if (isFrom) {
            setBackgroundDrawable(getResources().getDrawable(R.drawable.online_chatfrom_bg));
            setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.online_chatfrom_voice_playing, 0);
            return;
        }
        setBackgroundDrawable(getResources().getDrawable(R.drawable.online_chatto_bg));
        setCompoundDrawablesWithIntrinsicBounds(R.drawable.online_chatto_voice_playing, 0, 0, 0);
    }

    /**
     *
     */
    public final void stopVoiceAnimation() {
        if (!isRunning) return;
        if (mAlphaAnimation != null && mAlphaAnimation.isInitialized()) {
            setAnimation(null);
        }
        isRunning = false;
        this.mChattingFromAnimationDrawable.stop();
        this.mChattingToAnimationDrawable.stop();
        restBackground();
    }

}
