package com.byh.module.onlineoutser.im.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;

import com.byh.module.onlineoutser.im.utils.UiUtil;


public class ColorPointHintView extends ShapeHintView {
    private int focusColor;
    private int normalColor;

    public ColorPointHintView(Context context, int focusColor, int normalColor) {
        super(context);
        this.focusColor = focusColor;
        this.normalColor = normalColor;
    }

    @Override
    public Drawable makeFocusDrawable() {
        GradientDrawable dot_focus = new GradientDrawable();
        dot_focus.setColor(focusColor);
        dot_focus.setCornerRadius(UiUtil.INSTANCE.dpToPx(4));
        dot_focus.setSize(UiUtil.INSTANCE.dpToPx(8), UiUtil.INSTANCE.dpToPx(8));
        return dot_focus;
    }

    @Override
    public Drawable makeNormalDrawable() {
        GradientDrawable dot_normal = new GradientDrawable();
        dot_normal.setColor(normalColor);
        dot_normal.setCornerRadius(UiUtil.INSTANCE.dpToPx(4));
        dot_normal.setSize(UiUtil.INSTANCE.dpToPx(8), UiUtil.INSTANCE.dpToPx(8));
        return dot_normal;
    }
}
