package com.byh.module.onlineoutser.im.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;

import com.byh.module.onlineoutser.im.utils.ImgUtil;

import java.util.List;

import cn.finalteam.galleryfinal.widget.zoonview.PhotoView;
import cn.finalteam.galleryfinal.widget.zoonview.PhotoViewAttacher;


/**
 * Created by poetr on 17/11/10.
 */

public class ImagePreviewView extends ViewPager {

    private List<String> mDatas;
    private ImageAdapter mAdapter;
    private ViewStateListener mListener;

    public ImagePreviewView(@NonNull Context context) {
        this(context, null);
    }

    public ImagePreviewView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        setBackgroundColor(Color.BLACK);
    }

    public void setDatas(List<String> url) {
        mDatas = url;
        setAdapter();
    }

    public void setDatas(List<String> url, int index) {
        mDatas = url;
        setAdapter();
        setCurrentItem(index);
    }

    public void setListener(ViewStateListener mListener) {
        this.mListener = mListener;
    }

    public void show(boolean b) {
        if (b) {
            setVisibility(View.VISIBLE);
            ValueAnimator animator = ValueAnimator.ofFloat(0f, 1f);
            animator.setInterpolator(new AccelerateInterpolator());
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
                @Override
                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    float rate = (float) valueAnimator.getAnimatedValue();
                    setAlpha(rate);
                    setScaleX(rate);
                    setScaleY(rate);
                }
            });
            animator.setDuration(300);
            animator.setTarget(this);
            animator.start();
            if (mListener != null) mListener.onShow();
        } else {
            ValueAnimator animator = ValueAnimator.ofFloat(1f, 0f);
            animator.setInterpolator(new AccelerateInterpolator());
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
                @Override
                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    float rate = (float) valueAnimator.getAnimatedValue();
                    setAlpha(rate);
                    setScaleX(rate);
                    setScaleY(rate);
                }
            });
            animator.setDuration(300);
            animator.setTarget(this);
            animator.addListener(new AnimatorListenerAdapter() {
                @Override
                public void onAnimationEnd(Animator animation) {
                    if (mListener != null) mListener.onDismiss();
                    setVisibility(GONE);
                }
            });
            animator.start();
        }
//        if (getContext() instanceof Activity) {
//            Activity ac = (Activity) getContext();
//            Globals.INSTANCE.fullScreen(ac.getWindow(), b);
//        }
    }

    public String getCurrentImage() {
        if (mDatas != null) return mDatas.get(getCurrentItem());
        return "";
    }

    private void setAdapter() {
        if (mAdapter == null) {
            mAdapter = new ImageAdapter(getContext(), mDatas);
            setAdapter(mAdapter);
        } else {
            mAdapter.setDatas(mDatas);
        }
    }

    public boolean onBack() {
        if (getVisibility() == VISIBLE) {
            show(false);
            return true;
        }
        return false;
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        try {
            return super.onInterceptTouchEvent(ev);
        } catch (IllegalArgumentException e) {
        } catch (ArrayIndexOutOfBoundsException e) {
        }
        return false;
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        try {
            return super.onTouchEvent(ev);
        } catch (IllegalArgumentException ex) {
        }
        return false;
    }

    public interface ViewStateListener {
        void onShow();

        void onDismiss();
    }

    class ImageAdapter extends PagerAdapter {

        private Context mContext;
        private List<String> mDatas;

        public ImageAdapter(Context mContext, List<String> mDatas) {
            this.mContext = mContext;
            this.mDatas = mDatas;
        }

        public void setDatas(List<String> data) {
            mDatas = data;
            notifyDataSetChanged();
        }

        @Override
        public int getCount() {
            return mDatas.size();
        }

        @Override
        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return view == object;
        }

        @NonNull
        @Override
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            PhotoView view = new PhotoView(mContext);
            ViewGroup.LayoutParams params = new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            view.setLayoutParams(params);
            view.setScaleType(ImageView.ScaleType.FIT_CENTER);
            ImgUtil.load(mDatas.get(position), view);
            view.setOnViewTapListener(new PhotoViewAttacher.OnViewTapListener() {
                @Override
                public void onViewTap(View view, float x, float y) {
                    show(false);
                }
            });
            container.addView(view);
            return view;
        }

        @Override
        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            container.removeView((View) object);
        }
    }

}
