package com.kangxin.common.base.mvp;

import android.content.Context;

import com.kangxin.common.base.kt.IFlushMoreView;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

import java.util.List;

public class BasePresenter {
    protected Context mContext;

    private int pageIndex = 1;
    private int pageSize = 10;


    @Deprecated
    public BasePresenter(Context mContext) {
        this.mContext = mContext;
    }

    public BasePresenter() {
        registerEventBus();
    }

    private void registerEventBus() {
        EventBus.getDefault().register(this);
    }

    @Subscribe
    public void defaultFun(String string) {

    }

    public int getPageIndex(boolean isGetMore) {
        if (isGetMore) {
            return ++pageIndex;
        }
        pageIndex = 1;
        return pageIndex;
    }

    public int getPageSize() {
        return pageSize;
    }


    /**
     * 如果你的页面需要刷新和加载功能，请调用该方法
     *
     * @param view
     * @param datas
     * @param isGetMore
     * @param <T>
     */
    protected <T> void fullData(IFlushMoreView view, List<T> datas, boolean isGetMore) {
        if (isGetMore) {
            if (datas != null && datas.size() > 0) {
                view.addMore(datas);
            } else {
                view.noMore();
            }
        } else if (datas != null && datas.size() > 0) {
            view.bindData(datas);
        } else {
            view.noData();
        }
    }


}
