package com.kangxin.common.base.rmvp;

import android.text.TextUtils;
import android.view.View;

import com.kangxin.common.annotation.ToolBarTitle;
import com.kangxin.common.widget.TiLinearLayout;

import java.lang.annotation.Annotation;

public abstract class BaseFragment extends com.kangxin.common.base.kt.BaseFragment {

    @Override
    public final void init() {

        if (rootView instanceof TiLinearLayout) {
            vToolTitleTextView = ((TiLinearLayout) rootView).getTitleText();
            vToolLeftImage = ((TiLinearLayout) rootView).getLeftImg();
            vTitleLayout = ((TiLinearLayout) rootView).getToolView();
            vRightTextView = ((TiLinearLayout) rootView).getRightText();
            vToolRightView = ((TiLinearLayout) rootView).getRightImg();
            vToolLeftImage.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    clickLeftBack();
                }
            });
            // initTitleByAnn();
        }
        goStart();
    }

    protected abstract void goStart();

    private void initTitleByAnn() {

        Class clazz = this.getClass();

        boolean isAddAnno = false;

        for (Annotation annotation : clazz.getAnnotations()) {
            if (annotation instanceof ToolBarTitle) {
                String title = ((ToolBarTitle) annotation).value();
                if (!TextUtils.isEmpty(title)) {
                    isAddAnno = true;
                    vToolTitleTextView.setText(title);
                }
                break;
            }
        }

        if (!isAddAnno) {
            vTitleLayout.setVisibility(View.GONE);
        }
    }

    protected void clickLeftBack() {
        pop();
    }

    protected void showLoading() {

    }

    protected void hideLoading() {

    }


}
