package com.kangxin.common.byh;

import android.util.Log;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;

import java.io.IOException;
import java.util.TreeMap;

import okhttp3.ResponseBody;
import retrofit2.Converter;


public class BYGsonResponseBodyConverter<T> implements Converter<ResponseBody, T> {
    private static final String TAG = "BYGsonResponseBodyConve";
    private final Gson gson;
    private final TypeAdapter<T> adapter;

    BYGsonResponseBodyConverter(Gson gson, TypeAdapter<T> adapter) {
        this.gson = gson;
        this.adapter = adapter;
    }

    @Override
    public T convert(ResponseBody value) throws IOException {

        JsonReader jsonReader = gson.newJsonReader(value.charStream());

        try {
            T result = adapter.read(jsonReader);
            if (jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonIOException("JSON document was not fully consumed.");
            }
            return result;
        } catch (Exception exception) {

            //拿出里面的值
            byte[] bytes = value.bytes();
            String s = new String(bytes);
            Log.i(TAG, "convert: exception:" + exception);

            Log.i(TAG, "convert: exception:json:" + s);

            TreeMap map = new TreeMap();
            try {

            } catch (Exception ex) {
                ex.printStackTrace();
                map = new TreeMap();
            }
            com.kangxin.common.base.ResponseBody<Object> objectResponseBody = new com.kangxin.common.base.ResponseBody<>();
            if (map.get("msg") != null) {
                objectResponseBody.setMsg(map.get("msg").toString());
            }
            if (map.get("code") != null) {
                objectResponseBody.setCode(map.get("code").toString());
            }
            if (map.get("errCode") != null) {
                objectResponseBody.setErrCode(map.get("errCode").toString());
            }

            objectResponseBody.setCode("0");
            objectResponseBody.setErrCode("");
            T result = adapter.fromJson(gson.toJson(objectResponseBody));
            exception.printStackTrace();
            return result;
        } finally {
            value.close();
        }
    }
}
