package com.kangxin.common.byh.util;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;

import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class ImgUtils {
    //保存文件到指定路径
    public static boolean saveImageToGallery(Context context, Bitmap bmp) {
        // 首先保存图片  dearxy是可以改的
//        String storePath = context.getFilesDir() + File.separator + "share";
        String storePath = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "share";
        File appDir = new File(storePath);
        if (!appDir.exists()) {
            appDir.mkdirs();
        }
        String fileName = System.currentTimeMillis() + ".jpg";
        File file = new File(appDir, fileName);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            //通过io流的方式来压缩保存图片
            boolean isSuccess = bmp.compress(Bitmap.CompressFormat.JPEG, 60, fos);
            fos.flush();
            fos.close();

            //把文件插入到系统图库
            MediaStore.Images.Media.insertImage(context.getContentResolver(), file.getAbsolutePath(), fileName, null);

            //保存图片后发送广播通知更新数据库
            Uri uri = Uri.fromFile(file);
            context.sendBroadcast(new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE, uri));
            if (isSuccess) {
                ToastUtils.showShort(StringsUtils.getString(R.string.commbyh_baocunchenggong));
                return true;
            } else {
                ToastUtils.showShort(StringsUtils.getString(R.string.commbyh_baocunshibai));
                return false;
            }
        } catch (IOException e) {
            e.printStackTrace();
            ToastUtils.showShort(StringsUtils.getString(R.string.commbyh_baocunshibai));
        }
        return false;
    }
}
