package com.kangxin.common.byh.util;

import android.annotation.SuppressLint;
import android.text.TextUtils;

import com.blankj.utilcode.util.TimeUtils;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtil {
    /**
     * 一些时间格式
     */
    public final static String FORMAT_TIME = "HH:mm";
    public final static String FORMAT_DATE_TIME = "yyyy-MM-dd HH:mm";
    public final static String FORMAT_DATE_TIME_SECOND = "yyyy-MM-dd HH:mm:ss";
    public final static String FORMAT_MONTH_DAY_TIME = "MM-dd HH:mm";
    public final static String FORMAT_DATE = "yyyy-MM-dd";

    public static String getFormatToday(String dateFormat) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        return formatter.format(currentTime);
    }

    public static Date stringToDate(String dateStr, String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        try {
            return formatter.parse(dateStr);
        } catch (ParseException e) {
            return null;
        }
    }

    public static String dateToString(Date date, String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        return formatter.format(date);
    }

    /**
     * 类似QQ/微信 聊天消息的时间
     */
    public static String getChatTime(boolean hasYear, long timesamp) {
        long clearTime = timesamp;
        String result;
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        Date today = new Date(System.currentTimeMillis());
        Date otherDay = new Date(clearTime);
        int temp = Integer.parseInt(sdf.format(today))
                - Integer.parseInt(sdf.format(otherDay));
        switch (temp) {
            case 0:
                result = StringsUtils.getString(R.string.commbyh_jintian_) + getHourAndMin(clearTime);
                break;
            case 1:
                result = StringsUtils.getString(R.string.commbyh_zuotian_) + getHourAndMin(clearTime);
                break;
            case 2:
                result = StringsUtils.getString(R.string.commbyh_qiantian_) + getHourAndMin(clearTime);
                break;
            default:
                result = getTime(hasYear, clearTime);
                break;
        }
        return result;
    }

    public static String getTime(boolean hasYear, long time) {
        String pattern = FORMAT_DATE_TIME;
        if (!hasYear) {
            pattern = FORMAT_MONTH_DAY_TIME;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(new Date(time));
    }

    private static String getHourAndMin(long time) {
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_TIME);
        return format.format(new Date(time));
    }

    /**
     * 获取当前日期是星期几<br>
     *
     * @param date
     * @return 当前日期是星期几
     */
    public static String getWeekOfDate(Date date) {
        String[] weekDays = {StringsUtils.getString(R.string.commbyh_xingqiri), StringsUtils.getString(R.string.commbyh_xingqiyi), StringsUtils.getString(R.string.commbyh_xingqier), StringsUtils.getString(R.string.commbyh_xingqisan), StringsUtils.getString(R.string.commbyh_xingqisi), StringsUtils.getString(R.string.commbyh_xingqiwu), StringsUtils.getString(R.string.commbyh_xingqiliu)};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(Calendar.DAY_OF_WEEK) - 1;
        if (w < 0)
            w = 0;
        return weekDays[w];
    }

    /**
     * 将Server传送的UTC时间转换为指定时区的时间
     */
    @SuppressLint("SimpleDateFormat")
    public static String converTime(String srcTime, TimeZone timezone) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        SimpleDateFormat dspFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String convertTime;
        Date result_date;
        long result_time = 0;
        // 如果传入参数异常，使用本地时间 
        if (null == srcTime)
            result_time = System.currentTimeMillis();
        else {
            try { // 将输入时间字串转换为UTC时间 
                sdf.setTimeZone(TimeZone.getTimeZone("GMT00:00"));
                result_date = sdf.parse(srcTime);
                result_time = result_date.getTime();
            } catch (Exception e) { // 出现异常时，使用本地时间
                result_time = System.currentTimeMillis();
                dspFmt.setTimeZone(TimeZone.getDefault());
                convertTime = dspFmt.format(result_time);
                return convertTime;
            }
        }
        // 设定时区 
        dspFmt.setTimeZone(timezone);
        convertTime = dspFmt.format(result_time);
        return convertTime;
    }

    /**
     * 将日期转换成时间戳
     *
     * @param date    日期  03-22 15:12
     * @param pattern 格式  MM-dd hh:mm
     * @return
     */
    public static String date2Timestamp(String date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            return String.valueOf(sdf.parse(date).getTime());
        } catch (ParseException e) {
            return "";
        }
    }

    public static String timeStamp2Date(long time, String format) {
        if (format == null || format.isEmpty()) {
            format = FORMAT_DATE_TIME_SECOND;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(time));
    }

    public static String dateToStamp(String date) {
        SimpleDateFormat sf1 = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sf2 = new SimpleDateFormat(StringsUtils.getString(R.string.commbyh_yyyynianmmyue));
        String sfStr = "";
        try {
            sfStr = sf2.format(sf1.parse(date));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return sfStr;
    }


    public static String timeToMinutes(long second) {
        long minutes = second / 60;
        long counterpart = second;
        long aminute = 60;
        counterpart %= aminute;
        return (minutes >= 10 ? minutes : "0" + minutes) + ":"
                + (counterpart >= 10 ? counterpart : "0" + counterpart);
    }

    public static String secondToTime(long second) {
        long counterpart = second;
        long aminute = 60;
        long ahour = aminute * 60;
        long aday = ahour * 24;
        long amonth = aday * 30;
        long ayear = aday * 365;

        long years = second / ayear;
        second %= ayear;
        long months = second / amonth;
        second %= amonth;
        long days = second / aday;
        second %= aday;
        long hours = second / ahour;
        second %= ahour;
        long minutes = second / aminute;
        second %= aminute;
        if (years > 0) {
            if (months > 0) {
                return years + StringsUtils.getString(R.string.commbyh_nian) + months + StringsUtils.getString(R.string.commbyh_yue) + days + StringsUtils.getString(R.string.commbyh_tian);
            } else {
                return years + StringsUtils.getString(R.string.commbyh_nian) + days + StringsUtils.getString(R.string.commbyh_tian);
            }
        } else if (months > 0) {
            return months + StringsUtils.getString(R.string.commbyh_yue) + days + StringsUtils.getString(R.string.commbyh_tian);
        } else if (counterpart > 3 * aday) {
            return days + StringsUtils.getString(R.string.commbyh_tian) + hours + StringsUtils.getString(R.string.commbyh_xiaoshi);
        } else {
            hours = counterpart / ahour;
            counterpart %= ahour;
            minutes = counterpart / aminute;
            counterpart %= aminute;
            return (hours >= 10 ? hours : "0" + hours) + ":"
                    + (minutes >= 10 ? minutes : "0" + minutes) + ":"
                    + (counterpart >= 10 ? counterpart : "0" + counterpart);
        }
    }

    //由出生日期获得年龄
    public static int getAge(String birthDay) throws Exception {

        Date date = TimeUtils.string2Date(birthDay, new SimpleDateFormat("yyyy-MM-dd"));

        Calendar cal = Calendar.getInstance();
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException(
                    "The birthDay is before Now.It's unbelievable!");
        }
        int yearNow = cal.get(Calendar.YEAR);
        int monthNow = cal.get(Calendar.MONTH);
        int dayOfMonthNow = cal.get(Calendar.DAY_OF_MONTH);
        cal.setTime(date);

        int yearBirth = cal.get(Calendar.YEAR);
        int monthBirth = cal.get(Calendar.MONTH);
        int dayOfMonthBirth = cal.get(Calendar.DAY_OF_MONTH);

        int age = yearNow - yearBirth;

        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) age--;
            } else {
                age--;
            }
        }
        return age;
    }

    public static long parseTimeDate(String time) {

        if (TextUtils.isEmpty(time)) {
            return -1;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = simpleDateFormat.parse(time);
            if (date != null) {
                return date.getTime();
            }
        } catch (ParseException e) {
            e.printStackTrace();
            return -1;
        }

        return -1;
    }

}
