package com.kangxin.common.byh.widget;

import android.content.Context;
import android.os.CountDownTimer;
import android.util.AttributeSet;
import android.webkit.WebView;
import android.widget.ProgressBar;

import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;

public class ProgressWebView extends WebView {
    private ProgressBar mProgressBar;
    private CountDownTimer timer;

    public ProgressWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        mProgressBar = new ProgressBar(context, null, android.R.attr.progressBarStyleHorizontal);
        mProgressBar.setLayoutParams(new LayoutParams(LayoutParams.MATCH_PARENT, 3, 0, 0));
        addView(mProgressBar);

        mProgressBar.setProgressDrawable(context.getResources().getDrawable(R.drawable.commbyh_web_progress_bar_states));
        getSettings().setDomStorageEnabled(true);
        setWebChromeClient(new WebChromeClient());
    }

    private void cancelCountDownTimer() {
        if (timer != null) {
            timer.cancel();
        }
        timer = null;
    }

    private void starCountDownTimer() {
        if (timer == null) {
            timer = new CountDownTimer(15000, 1000) {
                @Override
                public void onTick(long millisUntilFinished) {
                }

                @Override
                public void onFinish() {
                    ToastUtils.showLong(StringsUtils.getString(R.string.commbyh_jiazaishibai));
                }
            };
            timer.start();
        }
    }

    @Override
    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        LayoutParams lp = (LayoutParams) mProgressBar.getLayoutParams();
        lp.x = l;
        lp.y = t;
        mProgressBar.setLayoutParams(lp);
        super.onScrollChanged(l, t, oldl, oldt);
    }

    public class WebChromeClient extends android.webkit.WebChromeClient {
        @Override
        public void onProgressChanged(WebView view, int newProgress) {
            if (newProgress == 100) {
                mProgressBar.setVisibility(GONE);
                cancelCountDownTimer();
            } else {
                if (mProgressBar.getVisibility() == GONE)
                    mProgressBar.setVisibility(VISIBLE);
                mProgressBar.setProgress(newProgress);
                starCountDownTimer();
            }
            super.onProgressChanged(view, newProgress);
        }
    }
}

