package com.kangxin.common.http.factory;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;

import java.io.IOException;

import okhttp3.ResponseBody;
import retrofit2.Converter;

public class GsonResponseBodyErrorConverter<T> implements Converter<ResponseBody, T> {

    private final Gson gson;
    private final TypeAdapter<T> adapter;

    public GsonResponseBodyErrorConverter(Gson gson, TypeAdapter<T> adapter) {
        this.gson = gson;
        this.adapter = adapter;
    }


    @Override
    public T convert(ResponseBody value) throws IOException {

        JsonObject json = gson.fromJson(value.string(), JsonObject.class);
        if (!json.get("resultCode").equals("200")) {
            json.addProperty("data", "");
        }

        return adapter.fromJson(json.toString());
    }
}
