package com.kangxin.common.imageshow;

import android.content.Context;
import android.content.Intent;

import com.kangxin.common.R;
import com.kangxin.common.base.rmvp.BaseActivity;

import java.util.ArrayList;
import java.util.List;

public class ImgListShowActivity extends BaseActivity {


    public static void startSelf(Context mContext, ArrayList<String> urlList, int currentItem) {

        Intent i = new Intent(mContext, ImgListShowActivity.class);
        i.putStringArrayListExtra("urlList", urlList);
        i.putExtra("currentItem", currentItem);
        mContext.startActivity(i);

    }

    @Override
    public void goStart() {

        List<String> urlList = getIntent().getStringArrayListExtra("urlList");

        int currentItem = getIntent().getIntExtra("currentItem", 0);

        ImgListShowFragment showFragment = new ImgListShowFragment(urlList);
        showFragment.setDefaultIndext(currentItem);

        loadRootFragment(R.id.root, showFragment);

    }

    @Override
    public int getContentLayoutId() {
        return R.layout.img_list_show_activity;
    }
}
