package com.kangxin.common.rx;

import android.accounts.NetworkErrorException;
import android.content.Context;
import android.util.Log;

import com.blankj.utilcode.util.ToastUtils;
import com.google.gson.JsonParseException;
import com.kangxin.common.BuildConfig;
import com.kangxin.common.R;
import com.kangxin.common.global.ErrorCode;
import com.kangxin.common.util.GlobeLoadingHelper;
import com.kangxin.common.util.StringsUtils;
import com.umeng.analytics.MobclickAgent;

import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

import io.reactivex.observers.DefaultObserver;
import retrofit2.HttpException;

public abstract class ProgressDialogObserver<T> extends DefaultObserver<T> {

    private static final String TAG = "ProgressDialogObserver";

    final String MSG = StringsUtils.getString(R.string.common_lianxikaifarenyuanjiejuewenti_cuowuma);

    String msg = "";

    //上下文
    private Context mContext;

    public ProgressDialogObserver() {
        super();
        mContext = attachContext();
    }

    //子线程
    @Override
    protected void onStart() {
        Log.i("ProgressDialog", "onstart " + Thread.currentThread().getName());
        onComplete();
        GlobeLoadingHelper.show(mContext);
    }

    @Override
    public abstract void onNext(T t);

    @Override
    public void onError(Throwable t) {

        Log.i("ProgressDialog", "onerror " + Thread.currentThread().getName());
        t.printStackTrace();
        GlobeLoadingHelper.dissmiss();
        if (t instanceof SocketTimeoutException) {
            msg = MSG + ErrorCode.INSTANCE.getSOCKET_TIME_OUT_ERROR();
        } else if (t instanceof NetworkErrorException || t instanceof HttpException) {
            msg = MSG + ErrorCode.INSTANCE.getNET_ERROR();
        } else if (t instanceof JsonParseException) {
            msg = MSG + ErrorCode.INSTANCE.getJSON_PARSE_ERROR();
        } else if (t instanceof NullPointerException) {
            msg = MSG + ErrorCode.INSTANCE.getNULL_POINT_ERROR();
        } else if (t instanceof ArrayIndexOutOfBoundsException) {
            msg = MSG + ErrorCode.INSTANCE.getARRAY_INDEX_OUT_ERROR();
        } else if (t instanceof UnknownHostException) {
            msg = StringsUtils.getString(R.string.common_qingjianchawangluolianjieshifoukeyong);
        } else {
            msg = MSG + ErrorCode.INSTANCE.getNO_KNOW_ERROR();
        }

        GlobeLoadingHelper.dissmiss();

        if (BuildConfig.DEBUG) {
            ToastUtils.showShort(t.getMessage());
        } else {
            MobclickAgent.reportError(mContext, t);
            ToastUtils.showShort(msg);
        }

    }

    @Override
    public void onComplete() {
        Log.i("ProgressDialog", "onstart " + Thread.currentThread().getName());
        GlobeLoadingHelper.dissmiss();
    }

    protected abstract Context attachContext();

}
