package com.kangxin.common.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.kangxin.common.R;

public class TiLinearLayout extends LinearLayout {

    private View toolView;
    private String title;
    private String rightText;

    public TiLinearLayout(Context context) {
        super(context);
    }

    public TiLinearLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(attrs);
    }

    public TiLinearLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(attrs);
    }

    private void init(AttributeSet attributeSet) {
        TypedArray typedArray = getContext().obtainStyledAttributes(attributeSet, R.styleable.TiLinearLayout);
        title = typedArray.getString(R.styleable.TiLinearLayout_title);
        rightText = typedArray.getString(R.styleable.TiLinearLayout_right_text);
        typedArray.recycle();
        inflate(getContext(), R.layout.tool_title, this);
        toolView = findViewById(R.id.vToolBar);
        toolView.<TextView>findViewById(R.id.vTitle).setText(title);
        toolView.<TextView>findViewById(R.id.vRightTextView).setText(rightText);
    }

    public View getToolView() {
        return toolView;
    }

    public ImageView getLeftImg() {
        return findViewById(R.id.vLeftImage);
    }

    public TextView getTitleText() {
        return findViewById(R.id.vTitle);
    }

    public ImageView getRightImg() {
        return findViewById(R.id.vRightImage);
    }

    public TextView getRightText() {
        return findViewById(R.id.vRightTextView);
    }

}
