package com.kangxin.doctor.worktable.util;

import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtil {
    /**
     * 一些时间格式
     */
    public final static String FORMAT_TIME = "HH:mm";
    public final static String FORMAT_DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public final static String FORMAT_DATE_TIME_SECOND = "yyyy-MM-dd HH:mm:ss";
    public final static String FORMAT_MONTH_DAY_TIME = "MM-dd HH:mm";
    public final static String FORMAT_DATE = "yyyy-MM-dd";

    public static String getFormatToday(String dateFormat) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        return formatter.format(currentTime);
    }


    public static String getFormatTime(Long time, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(time);
    }

    public static Date stringToDate(String dateStr, String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        try {
            return formatter.parse(dateStr);
        } catch (ParseException e) {
            return null;
        }
    }

    public static String dateToString(Date date, String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        return formatter.format(date);
    }

    /**
     * 类似QQ/微信 聊天消息的时间
     */
    public static String getChatTime(boolean hasYear, long timesamp) {
        long clearTime = timesamp;
        String result;
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        Date today = new Date(System.currentTimeMillis());
        Date otherDay = new Date(clearTime);
        int temp = Integer.parseInt(sdf.format(today))
                - Integer.parseInt(sdf.format(otherDay));
        switch (temp) {
            case 0:
                result = StringsUtils.getString(R.string.worktab_jintian_) + getHourAndMin(clearTime);
                break;
            case 1:
                result = StringsUtils.getString(R.string.worktab_zuotian_) + getHourAndMin(clearTime);
                break;
            case 2:
                result = StringsUtils.getString(R.string.worktab_qiantian_) + getHourAndMin(clearTime);
                break;
            default:
                result = getTime(hasYear, clearTime);
                break;
        }
        return result;
    }

    public static String getTime(boolean hasYear, long time) {
        String pattern = FORMAT_DATE_TIME;
        if (!hasYear) {
            pattern = FORMAT_MONTH_DAY_TIME;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(new Date(time));
    }

    private static String getHourAndMin(long time) {
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_TIME);
        return format.format(new Date(time));
    }

    /**
     * 获取当前日期是星期几<br>
     *
     * @param date
     * @return 当前日期是星期几
     */
    public static String getWeekOfDate(Date date) {
        String[] weekDays = {StringsUtils.getString(R.string.worktab_xingqiri), StringsUtils.getString(R.string.worktab_xingqiyi), StringsUtils.getString(R.string.worktab_xingqier), StringsUtils.getString(R.string.worktab_xingqisan), StringsUtils.getString(R.string.worktab_xingqisi), StringsUtils.getString(R.string.worktab_xingqiwu), StringsUtils.getString(R.string.worktab_xingqiliu)};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(Calendar.DAY_OF_WEEK) - 1;
        if (w < 0)
            w = 0;
        return weekDays[w];
    }

    /**
     * utc时间转成local时间
     *
     * @param date
     * @return
     */
    public static String utc2Local(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'X'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateUtcTime = sdf.format(date);
        Date utcDate = null;
        try {
            utcDate = sdf.parse(dateUtcTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        sdf.setTimeZone(TimeZone.getDefault());
        Date localDate = null;
        String localTime = sdf.format(utcDate.getTime());
        try {
            localDate = sdf.parse(localTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return sdf1.format(localDate);
    }

    /**
     * utc时间转成local时间
     *
     * @param date
     * @return
     */
    public static String utc2Local2(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'X'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateUtcTime = sdf.format(date);
        Date utcDate = null;
        try {
            utcDate = sdf.parse(dateUtcTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        sdf.setTimeZone(TimeZone.getDefault());
        Date localDate = null;
        String localTime = sdf.format(utcDate.getTime());
        try {
            localDate = sdf.parse(localTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        SimpleDateFormat sdf1 = new SimpleDateFormat(StringsUtils.getString(R.string.worktab_yyyynianmmyueddri_hh_mm));
        return sdf1.format(localDate);
    }

    /**
     * 将日期转换成时间戳
     *
     * @param date    日期  03-22 15:12
     * @param pattern 格式  MM-dd hh:mm
     * @return
     */
    public static String date2Timestamp(String date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            return String.valueOf(sdf.parse(date).getTime());
        } catch (ParseException e) {
            return "";
        }
    }

    public static String timeStamp2Date(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(time));
    }

    // strTime要转换的String类型的时间
    // formatType时间格式
    // strTime的时间格式和formatType的时间格式必须相同
    public static long stringToLong(String strTime, String formatType) {
        Date date = stringToDate(strTime, formatType); // String类型转成date类型
        if (date == null) {
            return 0;
        } else {
            long currentTime = date.getTime(); // date类型转成long类型
            return currentTime;
        }
    }

    public static String dateToStamp(String date) {
        SimpleDateFormat sf1 = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sf2 = new SimpleDateFormat(StringsUtils.getString(R.string.worktab_yyyynianmmyue));
        String sfStr = "";
        try {
            sfStr = sf2.format(sf1.parse(date));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return sfStr;
    }

    public static String getFixString(final long millis1,
                                      final long millis2,
                                      final int precision) {


        long millis = millis1 - millis2;

        if (precision <= 0) return null;
        int newPre = Math.min(precision, 5);
        String[] units = {":", ":", ":", ":", ":"};
        if (millis == 0) return 0 + units[newPre - 1];
        StringBuilder sb = new StringBuilder();
        if (millis < 0) {
            sb.append("-");
            millis = -millis;
        }
        int[] unitLen = {86400000, 3600000, 60000, 1000, 1};
        for (int i = 0; i < newPre; i++) {
            if (millis >= unitLen[i]) {
                long mode = millis / unitLen[i];
                millis -= mode * unitLen[i];
                sb.append(mode).append(units[i]);
            }
        }
        return sb.toString();

    }


}
