/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.base.rmvp;

import com.kangxin.common.base.mvp.BaseModel;
import com.kangxin.common.base.rmvp.IPresenter;
import com.kangxin.common.base.rmvp.IView;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public class BasePresenter<V extends IView, M extends BaseModel>
implements IPresenter {
    protected V v;
    protected M m;

    private static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(BasePresenter.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return BasePresenter.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    protected void injectView(V v) {
        this.v = v;
        this.m = this.autoCreatModel();
    }

    protected boolean isAttachView() {
        return this.v != null;
    }

    private M autoCreatModel() {
        try {
            Type superClass = this.getClass().getGenericSuperclass();
            Type type = ((ParameterizedType)superClass).getActualTypeArguments()[1];
            Class<?> clazz = BasePresenter.getRawType(type);
            return (M)((BaseModel)clazz.newInstance());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void destroy() {
        this.v = null;
        this.m = null;
    }
}

