/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import com.kangxin.common.R;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import java.util.List;

public class DefaultEmptyPage {
    private ViewGroup mBusViewGroup;
    private View mDefView;

    public void showDef(boolean isShow) {
        if (isShow) {
            this.mDefView.setVisibility(0);
            this.mBusViewGroup.setVisibility(8);
        } else {
            this.mDefView.setVisibility(8);
            this.mBusViewGroup.setVisibility(0);
        }
    }

    public static class Builder<T> {
        private ViewGroup mBusViewGroup;
        @DrawableRes
        private int mImgId;
        private String mBtnText;
        private String mDefDescText;
        private String mDefDescEnglishText;
        private Context mContext;
        private OnDefpageClickListener onDefpageClickListener;
        private List<T> mDataList;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setDefDescText(String text) {
            this.mDefDescText = text;
            return this;
        }

        public Builder setDefEngText(String engText) {
            this.mDefDescEnglishText = engText;
            return this;
        }

        public Builder setDataList(List<T> dataList) {
            this.mDataList = dataList;
            return this;
        }

        public Builder setBusViewGroup(ViewGroup viewGroup) {
            this.mBusViewGroup = viewGroup;
            return this;
        }

        public Builder setDefImgid(@DrawableRes int imgId) {
            this.mImgId = imgId;
            return this;
        }

        public Builder setDefBtnText(String btnText) {
            this.mBtnText = btnText;
            return this;
        }

        public Builder setOnDefpageClickListener(OnDefpageClickListener onDefpageClickListener) {
            this.onDefpageClickListener = onDefpageClickListener;
            return this;
        }

        public DefaultEmptyPage create() {
            DefaultEmptyPage defaultEmptyPage = new DefaultEmptyPage();
            defaultEmptyPage.mBusViewGroup = this.mBusViewGroup;
            View defView = View.inflate((Context)this.mContext, (int)R.layout.commbyh_list_empty_place2, null);
            defaultEmptyPage.mDefView = defView;
            ImageView placeImgView = (ImageView)defView.findViewById(R.id.place_img);
            if (this.mImgId != 0) {
                placeImgView.setImageResource(this.mImgId);
            }
            TextView defDescView = (TextView)defView.findViewById(R.id.place_seat_desc);
            if (!TextUtils.isEmpty((CharSequence)this.mDefDescText)) {
                defDescView.setText((CharSequence)this.mDefDescText);
            }
            TextView defDescView2 = (TextView)defView.findViewById(R.id.place_seat_desc2);
            if (!TextUtils.isEmpty((CharSequence)this.mDefDescEnglishText)) {
                defDescView2.setText((CharSequence)this.mDefDescEnglishText);
            }
            TextView defBtn = (TextView)defView.findViewById(R.id.def_page_btn);
            if (!TextUtils.isEmpty((CharSequence)this.mBtnText)) {
                defBtn.setText((CharSequence)this.mBtnText);
            }
            defBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (onDefpageClickListener != null) {
                        onDefpageClickListener.onClickDefbtn(v);
                    }
                }
            });
            ViewParent parent = this.mBusViewGroup.getParent();
            ViewGroup parentGroupView = null;
            if (parent instanceof ViewGroup) {
                parentGroupView = (ViewGroup)parent;
            }
            if (this.mDataList != null && this.mDataList.size() > 0) {
                this.mBusViewGroup.setVisibility(0);
                defView.setVisibility(8);
            } else {
                this.mBusViewGroup.setVisibility(8);
                defView.setVisibility(0);
            }
            if (parentGroupView != null && !this.hasDefView(parentGroupView, defView)) {
                if (parentGroupView instanceof SmartRefreshLayout) {
                    throw new RuntimeException("SmartRefreshLayout must have only a child view, please add a only view!!!");
                }
                parentGroupView.addView(defView);
            }
            return defaultEmptyPage;
        }

        private boolean hasDefView(ViewGroup viewGroup, View defViewGroup) {
            int childCount = viewGroup.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View childView = viewGroup.getChildAt(i);
                if (childView != defViewGroup) continue;
                return true;
            }
            return false;
        }
    }

    public static interface OnDefpageClickListener {
        public void onClickDefbtn(View var1);
    }
}

