/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.guide.core;

import android.app.Activity;
import android.app.Fragment;
import android.text.TextUtils;
import android.view.View;
import com.kangxin.common.guide.core.Controller;
import com.kangxin.common.guide.listener.OnGuideChangedListener;
import com.kangxin.common.guide.listener.OnPageChangedListener;
import com.kangxin.common.guide.model.GuidePage;
import java.util.ArrayList;
import java.util.List;

public class Builder {
    Activity activity;
    Fragment fragment;
    String label;
    boolean alwaysShow;
    View anchor;
    int showCounts = 1;
    OnGuideChangedListener onGuideChangedListener;
    OnPageChangedListener onPageChangedListener;
    List<GuidePage> guidePages = new ArrayList<GuidePage>();

    public Builder(Activity activity) {
        this.activity = activity;
    }

    public Builder(Fragment fragment) {
        this.fragment = fragment;
        this.activity = fragment.getActivity();
    }

    public Builder anchor(View anchor) {
        this.anchor = anchor;
        return this;
    }

    public Builder setShowCounts(int count) {
        this.showCounts = count;
        return this;
    }

    public Builder alwaysShow(boolean b) {
        this.alwaysShow = b;
        return this;
    }

    public Builder addGuidePage(GuidePage page) {
        this.guidePages.add(page);
        return this;
    }

    public Builder setOnGuideChangedListener(OnGuideChangedListener listener2) {
        this.onGuideChangedListener = listener2;
        return this;
    }

    public Builder setOnPageChangedListener(OnPageChangedListener onPageChangedListener) {
        this.onPageChangedListener = onPageChangedListener;
        return this;
    }

    public Builder setLabel(String label) {
        this.label = label;
        return this;
    }

    public Controller build() {
        this.check();
        return new Controller(this);
    }

    public Controller show() {
        this.check();
        Controller controller = new Controller(this);
        controller.show();
        return controller;
    }

    private void check() {
        if (TextUtils.isEmpty((CharSequence)this.label)) {
            throw new IllegalArgumentException("the param 'label' is missing, please call setLabel()");
        }
        if (this.activity == null && this.fragment != null) {
            throw new IllegalStateException("activity is null, please make sure that fragment is showing when call NewbieGuide");
        }
    }
}

