/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.guide.model;

import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import com.kangxin.common.guide.model.HighLight;
import com.kangxin.common.guide.model.HighlightOptions;
import com.kangxin.common.guide.util.LogUtil;
import com.kangxin.common.guide.util.ViewUtils;

public class HighlightView
implements HighLight {
    private View mHole;
    private HighLight.Shape shape;
    private int round;
    private int padding;
    private HighlightOptions options;
    private RectF rectF;

    public HighlightView(View mHole, HighLight.Shape shape, int round, int padding) {
        this.mHole = mHole;
        this.shape = shape;
        this.round = round;
        this.padding = padding;
    }

    public void setOptions(HighlightOptions options) {
        this.options = options;
    }

    @Override
    public HighLight.Shape getShape() {
        return this.shape;
    }

    @Override
    public int getRound() {
        return this.round;
    }

    @Override
    public HighlightOptions getOptions() {
        return this.options;
    }

    @Override
    public float getRadius() {
        if (this.mHole == null) {
            throw new IllegalArgumentException("the highlight view is null!");
        }
        return Math.max(this.mHole.getWidth() / 2, this.mHole.getHeight() / 2) + this.padding;
    }

    @Override
    public RectF getRectF(View target) {
        if (this.mHole == null) {
            throw new IllegalArgumentException("the highlight view is null!");
        }
        if (this.rectF == null) {
            this.rectF = this.fetchLocation(target);
        } else if (this.options != null && this.options.fetchLocationEveryTime) {
            this.rectF = this.fetchLocation(target);
        }
        LogUtil.i(this.mHole.getClass().getSimpleName() + "'s location:" + this.rectF);
        return this.rectF;
    }

    private RectF fetchLocation(View target) {
        RectF location = new RectF();
        Rect locationInView = ViewUtils.getLocationInView(target, this.mHole);
        location.left = locationInView.left - this.padding;
        location.top = locationInView.top - this.padding;
        location.right = locationInView.right + this.padding;
        location.bottom = locationInView.bottom + this.padding;
        return location;
    }
}

