/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.guide.model;

import android.content.Context;
import android.graphics.RectF;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.LayoutRes;
import com.kangxin.common.guide.core.Controller;
import com.kangxin.common.guide.model.HighLight;
import com.kangxin.common.guide.util.LogUtil;

public class RelativeGuide {
    public HighLight highLight;
    @LayoutRes
    public int layout;
    public int padding;
    public int gravity;

    public RelativeGuide(@LayoutRes int layout2, int gravity) {
        this.layout = layout2;
        this.gravity = gravity;
    }

    public RelativeGuide(@LayoutRes int layout2, int gravity, int padding) {
        this.layout = layout2;
        this.gravity = gravity;
        this.padding = padding;
    }

    public final View getGuideLayout(ViewGroup viewGroup, Controller controller) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(this.layout, viewGroup, false);
        this.onLayoutInflated(view);
        this.onLayoutInflated(view, controller);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        MarginInfo marginInfo = this.getMarginInfo(this.gravity, viewGroup, view);
        LogUtil.e(marginInfo.toString());
        this.offsetMargin(marginInfo, viewGroup, view);
        layoutParams.gravity = marginInfo.gravity;
        layoutParams.leftMargin += marginInfo.leftMargin;
        layoutParams.topMargin += marginInfo.topMargin;
        layoutParams.rightMargin += marginInfo.rightMargin;
        layoutParams.bottomMargin += marginInfo.bottomMargin;
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return view;
    }

    private MarginInfo getMarginInfo(int gravity, ViewGroup viewGroup, View view) {
        MarginInfo marginInfo = new MarginInfo();
        RectF rectF = this.highLight.getRectF((View)viewGroup);
        switch (gravity) {
            case 3: {
                marginInfo.gravity = 5;
                marginInfo.rightMargin = (int)((float)viewGroup.getWidth() - rectF.left + (float)this.padding);
                marginInfo.topMargin = (int)rectF.top;
                break;
            }
            case 48: {
                marginInfo.gravity = 80;
                marginInfo.bottomMargin = (int)((float)viewGroup.getHeight() - rectF.top + (float)this.padding);
                marginInfo.leftMargin = (int)rectF.left;
                break;
            }
            case 5: {
                marginInfo.leftMargin = (int)(rectF.right + (float)this.padding);
                marginInfo.topMargin = (int)rectF.top;
                break;
            }
            case 80: {
                marginInfo.topMargin = (int)(rectF.bottom + (float)this.padding);
                marginInfo.leftMargin = (int)rectF.left;
            }
        }
        return marginInfo;
    }

    protected void offsetMargin(MarginInfo marginInfo, ViewGroup viewGroup, View view) {
    }

    @Deprecated
    protected void onLayoutInflated(View view) {
    }

    protected void onLayoutInflated(View view, Controller controller) {
    }

    public static class MarginInfo {
        public int leftMargin;
        public int topMargin;
        public int rightMargin;
        public int bottomMargin;
        public int gravity;

        public String toString() {
            return "MarginInfo{leftMargin=" + this.leftMargin + ", topMargin=" + this.topMargin + ", rightMargin=" + this.rightMargin + ", bottomMargin=" + this.bottomMargin + ", gravity=" + this.gravity + '}';
        }
    }
}

