/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.util;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import java.util.Stack;

public class AppManager {
    private static Stack<Activity> activityStack;
    private static volatile AppManager instance;

    private AppManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppManager getAppManager() {
        if (instance != null) return instance;
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            if (instance != null) return instance;
            instance = new AppManager();
            activityStack = new Stack();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addActivity(Activity activity) {
        if (activityStack == null) {
            activityStack = new Stack();
        }
        activityStack.add(activity);
    }

    public Activity currentActivity() {
        try {
            Activity activity = (Activity)activityStack.lastElement();
            return activity;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Activity preActivity() {
        int index = activityStack.size() - 2;
        if (index < 0) {
            return null;
        }
        Activity activity = (Activity)activityStack.get(index);
        return activity;
    }

    public void finishActivity() {
        Activity activity = (Activity)activityStack.lastElement();
        this.finishActivity(activity);
    }

    public void finishActivity(Activity activity) {
        if (activity != null) {
            activityStack.remove(activity);
            activity.finish();
            activity = null;
        }
    }

    public void finishActivity(Activity ... activitys) {
        if (activitys != null) {
            for (Activity activity : activitys) {
                activityStack.remove(activity);
                activity.finish();
                activity = null;
            }
        }
    }

    public void removeActivity(Activity activity) {
        if (activity != null) {
            activityStack.remove(activity);
            activity = null;
        }
    }

    public void finishActivity(Class<?> cls) {
        try {
            for (Activity activity : activityStack) {
                if (!activity.getClass().equals(cls)) continue;
                this.finishActivity(activity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finishActivity(Class<?> ... cls) {
        try {
            for (Activity activity : activityStack) {
                for (Class<?> cl : cls) {
                    if (!activity.getClass().equals(cl)) continue;
                    this.finishActivity(activity);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finishAllActivity() {
        int size = activityStack.size();
        for (int i = 0; i < size; ++i) {
            if (null == activityStack.get(i)) continue;
            ((Activity)activityStack.get(i)).finish();
        }
        activityStack.clear();
    }

    public void returnToActivity(Class<?> cls) {
        while (activityStack.size() != 0 && activityStack.peek().getClass() != cls) {
            this.finishActivity(activityStack.peek());
        }
    }

    public boolean isOpenActivity(Class<?> cls) {
        if (activityStack != null) {
            int size = activityStack.size();
            for (int i = 0; i < size; ++i) {
                if (cls != activityStack.peek().getClass()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void AppExit(Context context, Boolean isBackground) {
        try {
            this.finishAllActivity();
            ActivityManager activityMgr = (ActivityManager)context.getSystemService("activity");
            activityMgr.restartPackage(context.getPackageName());
        }
        catch (Exception exception) {
        }
        finally {
            if (!isBackground.booleanValue()) {
                System.exit(0);
            }
        }
    }
}

