package com.byh.module.verlogin.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kangxin.common.R;

public class VertifyGridLabels extends RelativeLayout {
    private Context mContext;

    public VertifyGridLabels(Context context) {
        this(context, null);
    }

    public VertifyGridLabels(Context context, AttributeSet attrs) {
        super(context, attrs);
        mContext = context;
        init(attrs);
    }

    private void init(AttributeSet attrs) {
        GridView gridView = new GridView(mContext);
        LayoutParams layoutParams = new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT);
        gridView.setLayoutParams(layoutParams);
        gridView.setNumColumns(3);

        gridView.setAdapter(new GridAdapter(getResources().getStringArray(R.array.verfy_labels)));
        addView(gridView);
    }

    private class GridAdapter extends BaseAdapter {

        private String[] mLabels;

        public GridAdapter(String[] mLabels) {
            this.mLabels = mLabels;
        }

        @Override
        public int getCount() {
            return mLabels.length;
        }

        @Override
        public Object getItem(int i) {
            return mLabels[i];
        }

        @Override
        public long getItemId(int i) {
            return i;
        }

        @Override
        public View getView(int i, View view, ViewGroup viewGroup) {
            View gridItem = LayoutInflater.from(mContext).inflate(R.layout.verfy_grid_item, null);
            TextView labelNameTextView = gridItem.findViewById(R.id.txt_label);
            labelNameTextView.setText(mLabels[i]);
            return gridItem;
        }
    }


}
