package com.kangxin.common;


import android.content.Context;

import com.blankj.utilcode.util.Utils;
import com.kangxin.common.imageloader.ImageLoader;
import com.kangxin.common.imageloader.Show;
import com.kangxin.common.imageloader.Style;
import com.kangxin.common.imageloader.ZipStrategy;
import com.kangxin.common.imageloader.factory.GlideClient;
import com.kangxin.common.imageloader.factory.GlideImageLoader;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class Pretty {

    /**
     * 实例
     */
    private static ImageLoader proxy;
    /**
     * 图片加载
     */
    private static ImageLoader imageLoader = null;
    private final Context mContext;
    /**
     * 图片展示工场
     */
    private final Show.Factory showFatory;
    /**
     * 压缩策略
     */
    private final ZipStrategy zipStrategy;

    /**
     * 展示风格
     */
    private int style;


    private Pretty(Context mContext, Show.Factory showFatory, ImageLoader imageLoader, ZipStrategy zipStrategy, int style) {
        this.mContext = mContext;
        this.showFatory = showFatory;
        Pretty.imageLoader = imageLoader;
        this.zipStrategy = zipStrategy;
        this.style = style;
    }


    public static ImageLoader create() {
        if (proxy == null) {
            new Pretty.Builder().init(Utils.getApp()).build();
            proxy = (ImageLoader) Proxy.newProxyInstance(imageLoader.getClass().getClassLoader(), imageLoader.getClass().getInterfaces(), new InvocationHandler() {
                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    ImageLoader invoke = null;
                    invoke = (ImageLoader) method.invoke(imageLoader, args);
                    return invoke;
                }
            });
        }
        return proxy;
    }


    public static final class Builder {

        private Show.Factory showFactory;

        private int style = Style.NORMAL;

        private ImageLoader imageLoader;

        private ZipStrategy zipStrategy;

        private Context mContext;

        public Builder init(Context context) {
            mContext = context;
            return this;
        }


        public Builder setShowFactory(Show.Factory factory) {
            this.showFactory = factory;
            return this;
        }

        public Builder setImageLoader(ImageLoader loader) {
            this.imageLoader = loader;
            return this;
        }

        public Builder setZipStrategy(ZipStrategy zipStrategy) {
            this.zipStrategy = zipStrategy;
            return this;
        }

        public void setStyle(int style) {
            this.style = style;
        }

        public Pretty build() {

            if (showFactory == null) {
                showFactory = new GlideClient(mContext);
            }

            if (imageLoader == null) {
                imageLoader = new GlideImageLoader(mContext);
            }

            if (zipStrategy == null) {

            }


            return new Pretty(mContext, showFactory, imageLoader, zipStrategy, style);
        }

    }


}
