package com.kangxin.common.base;

import android.app.Activity;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.Toast;

import com.kangxin.common.http.entity.NetResponseMessage;
import com.kangxin.common.util.LoadingUtil;
import com.umeng.analytics.MobclickAgent;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import butterknife.ButterKnife;
import butterknife.Unbinder;

@Deprecated
public abstract class ByhBaseActivity extends BaseActivity {
    private static final String TAG = "ByhBaseActivity";
    public Bundle mBundle;
    protected Activity mActivity;
    private Unbinder mUnbinder;

    @Override
    public void initView() {
        if (getActionBar() != null) {
            getActionBar().hide();
        }
        mUnbinder = ButterKnife.bind(this);
        initEvent();
    }

    private void initEvent() {
        if (!EventBus.getDefault().isRegistered(this)) {
            EventBus.getDefault().register(this);
        }

    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEventMainThread(NetResponseMessage netResponseMessage) {
    }

    @Override
    public void initData() {
        mBundle = getIntent().getExtras();
        mActivity = this;

    }

    public void showToast(final String message) {
        if (TextUtils.isEmpty(message)) return;
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Toast.makeText(getBaseContext(), message, Toast.LENGTH_LONG).show();
            }
        });
    }

    @Override
    protected void onResume() {
        super.onResume();
        MobclickAgent.onResume(this);
    }

    @Override
    protected void onPause() {
        super.onPause();
        MobclickAgent.onPause(this);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (mUnbinder != null)
            mUnbinder.unbind();
        LoadingUtil.clossLoadingActivity();
        EventBus.getDefault().unregister(this);
    }

}

