package com.kangxin.common.base.rmvp;

import android.os.Bundle;

import androidx.annotation.Nullable;

import com.kangxin.common.base.mvp.BaseModel;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public abstract class MvpFragment<V extends IView, P extends BasePresenter<V, ? extends BaseModel>> extends BaseFragment implements IView {

    protected P p;

    // type不能直接实例化对象，通过type获取class的类型，然后实例化对象
    private static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class) type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType) type;
            Type rawType = parameterizedType.getRawType();
            return (Class) rawType;
        } else if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType) type).getGenericComponentType();
            return Array.newInstance(getRawType(componentType), 0).getClass();
        } else if (type instanceof TypeVariable) {
            return Object.class;
        } else if (type instanceof WildcardType) {
            return getRawType(((WildcardType) type).getUpperBounds()[0]);
        } else {
            String className = type == null ? "null" : type.getClass().getName();
            throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
        }
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        p = autoCreatPresenter();
        if (p != null)
            p.injectView((V) this);
        super.onCreate(savedInstanceState);
    }

    private P autoCreatPresenter() {

        try {
            Type superClass = getClass().getGenericSuperclass();
            Type type = ((ParameterizedType) superClass).getActualTypeArguments()[1];
            Class<P> clazz = (Class<P>) getRawType(type);
            return clazz.newInstance();
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }

    //如果P是通过其他方式实例化,需手动实现
    protected void injectPresenter(P p) {

        if (p == null)
            try {
                throw new Exception("P Instance dose not null");
            } catch (Exception e) {
                e.printStackTrace();
                return;
            }

        this.p = p;

        p.injectView((V) this);
    }

    @Override
    public void showLoading() {
        super.showLoading();
    }

    @Override
    public void hideLoading() {
        super.hideLoading();
    }


    @Override
    public void onDestroy() {
        p.destroy();
        p = null;
        super.onDestroy();
    }
}
