package com.kangxin.common.byh.keyboard;

import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnFocusChangeListener;
import android.view.View.OnTouchListener;
import android.widget.EditText;

public class KeyboardUtils {
    public KeyboardUtils() {
    }

    public static void bindEditTextEvent(final BaseKeyboard customKeyboard, EditText editText) {
        editText.setOnFocusChangeListener(new OnFocusChangeListener() {
            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    customKeyboard.hideKeyboard();
                }

            }
        });
        editText.setOnTouchListener(new OnTouchListener() {
            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getActionMasked() == 1) {
                    customKeyboard.showKeyboard();
                }

                return false;
            }
        });
        customKeyboard.attachTo(editText);
    }
}