package com.kangxin.common.byh.progress;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

public class LoadingView extends View {
    private Paint mPaint;
    private int mWidth;
    private int mHeight;
    private int mLineCount = 12;
    private double mPerDegree;
    private int mDuration = 450;
    private int mInvalidateTime;
    private long mCurrentTime;

    public LoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        float density = context.getResources().getDisplayMetrics().density;
        this.mPaint = new Paint(1);
        this.mPaint.setColor(-1);
        this.mPaint.setStrokeWidth(1.5F * density);
        this.mPerDegree = 6.283185307179586D / (double) this.mLineCount;
        this.mInvalidateTime = this.mDuration / this.mLineCount;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float halfW = (float) this.mWidth / 2.0F;
        canvas.translate(halfW, (float) this.mHeight / 2.0F);

        for (int i = 0; i < this.mLineCount; ++i) {
            float half = halfW / 2.0F;
            double degree = (double) i * this.mPerDegree + this.mPerDegree * (double) this.mCurrentTime / (double) this.mInvalidateTime;
            float startX = (float) ((double) half * Math.sin(degree));
            float startY = (float) ((double) half * Math.cos(degree));
            this.mPaint.setColor(Color.argb((int) (255.0F * (1.0F - (float) i * 1.0F / 1.25F / (float) this.mLineCount)), 255, 255, 255));
            canvas.drawLine(startX, startY, (float) ((double) halfW * Math.sin(degree)), (float) ((double) halfW * Math.cos(degree)), this.mPaint);
        }

        this.postInvalidateDelayed((long) this.mInvalidateTime);
        this.mCurrentTime += (long) this.mInvalidateTime;
    }
}

