package com.kangxin.common.byh.widget;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;

import androidx.recyclerview.widget.RecyclerView;

import com.kangxin.common.R;

import java.util.List;

public class DefEmptyPageProxy {

  private static final String TAG = "DefEmptyPageProxy";
  private static DefEmptyPageProxy INSTANCE ;
  private Context mContext;
  private DefaultEmptyPage mDefEmptyPage;
  private DefaultEmptyPage.OnDefpageClickListener onDefpageClickListener;

  public enum DefEmptyType{
    NO_RECORDS, //无记录
    NO_PAGE, //无页面
    NO_SEARCH_RESULT,//无搜索结果
    NET_EXCEPTION, //网络异常
    NO_GROUP_CHATS, //没有群聊
    NO_HEALTH_MANAGERS, //无健康管理计划
    NO_AUTH, //权限未开通
  }

  private DefEmptyPageProxy(Context context) {
    mContext = context;
  }

  public static DefEmptyPageProxy getInstance(Context context){
    if(INSTANCE == null){
      INSTANCE = new DefEmptyPageProxy(context);
    }
    return INSTANCE;
  }

  public <T> void createDefEmptyPage(ViewGroup busGroupView, DefEmptyType defEmptyType){
    createDefEmptyPage(null, busGroupView, defEmptyType);
  }

  public <T> void createDefEmptyPage(List<T> dataList, ViewGroup busGroupView, DefEmptyType defEmptyType){
    switch (defEmptyType){
      case NO_RECORDS:
        mDefEmptyPage = new DefaultEmptyPage.Builder<T>(mContext)
          .setBusViewGroup(busGroupView)
          .setDataList(dataList)
          .setOnDefpageClickListener(onDefpageClickListener)
          .create();
        break;
      case NO_PAGE:
        mDefEmptyPage = new DefaultEmptyPage.Builder<T>(mContext)
          .setBusViewGroup(busGroupView)
          .setDataList(dataList)
          .setOnDefpageClickListener(onDefpageClickListener)
          .setDefImgid(R.drawable.ic_defnopage_img)
          .setDefDescText(getString(R.string.commbyh_zanwuyem))
          .setDefEngText(getString(R.string.commbyh_zanwuyem_eng))
          .setDefBtnText(getString(R.string.commbyh_wozhidle))
          .create();
        break;
      case NO_SEARCH_RESULT:
        mDefEmptyPage = new DefaultEmptyPage.Builder<T>(mContext)
          .setBusViewGroup(busGroupView)
          .setDataList(dataList)
          .setOnDefpageClickListener(onDefpageClickListener)
          .setDefImgid(R.drawable.ic_defnosearch_img)
          .setDefDescText(getString(R.string.commbyh_nosearch_result))
          .setDefEngText(getString(R.string.commbyh_nosearch_result_eng))
          .setDefBtnText(getString(R.string.commbyh_wozhidle))
          .create();
        break;
      case NET_EXCEPTION:
        mDefEmptyPage = new DefaultEmptyPage.Builder<T>(mContext)
          .setBusViewGroup(busGroupView)
          .setDataList(dataList)
          .setOnDefpageClickListener(onDefpageClickListener)
          .setDefImgid(R.drawable.ic_defnet_exception)
          .setDefDescText(getString(R.string.comm_net_exception))
          .setDefEngText(getString(R.string.comm_net_exception_eng))
          .setDefBtnText(getString(R.string.comm_check_net))
          .create();
        break;
      case NO_GROUP_CHATS:
        mDefEmptyPage = new DefaultEmptyPage.Builder<T>(mContext)
                .setBusViewGroup(busGroupView)
                .setDataList(dataList)
                .setOnDefpageClickListener(onDefpageClickListener)
                .setDefImgid(R.drawable.ic_defno_groupchat)
                .setDefDescText(getString(R.string.byhim_commbyh_def_nochatgroupdesc))
                .setDefEngText(getString(R.string.byhim_commbyh_def_nochatgroupdesc_eng))
                .setDefBtnText(getString(R.string.byhim_start_groupchat))
                .create();
        break;
      case NO_HEALTH_MANAGERS:
        mDefEmptyPage = new DefaultEmptyPage.Builder<T>(mContext)
                .setBusViewGroup(busGroupView)
                .setDataList(dataList)
                .setOnDefpageClickListener(onDefpageClickListener)
                .setDefImgid(R.drawable.ic_defno_health_manager)
                .setDefDescText(getString(R.string.comm_no_health_manager))
                .setDefEngText(getString(R.string.comm_no_health_manager_eng))
                .setDefBtnText(getString(R.string.comm_make_healthmanager_plan))
                .create();
        break;
      case NO_AUTH:
        mDefEmptyPage = new DefaultEmptyPage.Builder<T>(mContext)
                .setBusViewGroup(busGroupView)
                .setDataList(dataList)
                .setOnDefpageClickListener(onDefpageClickListener)
                .setDefImgid(R.drawable.ic_defpage_no_auth)
                .setDefDescText(getString(R.string.comm_no_auth))
                .setDefEngText(getString(R.string.comm_no_auth_eng))
                .setDefBtnText(getString(R.string.comm_open_auth))
                .create();
        break;
    }
  }



  public void showNetErrPage(ViewGroup viewGroup){
      ViewGroup recyclerView = findRecyclerView(viewGroup);
      if(recyclerView != null){
        getInstance(viewGroup.getContext()).setOnDefpageClickListener(new DefaultEmptyPage.OnDefpageClickListener() {
          @Override
          public void onClickDefbtn(View view) {
            //点击检查网络的按钮
          }
        });
        getInstance(viewGroup.getContext()).createDefEmptyPage(recyclerView, DefEmptyType.NET_EXCEPTION);
      }
  }

  public void showDefPage(boolean isShow){
    if(mDefEmptyPage != null){
      mDefEmptyPage.showDef(isShow);
    }
  }


  public ViewGroup findRecyclerView(ViewGroup viewGroup){
    int childCount = viewGroup.getChildCount();
    for (int i = 0; i < childCount; i++) {
      View view = viewGroup.getChildAt(i);
      if(view instanceof RecyclerView){
        return (ViewGroup) view;
      }else if(view instanceof ViewGroup) {
        Log.i(TAG, "findRecyclerView: viewGroup==>" + view.getClass().getSimpleName());
        findRecyclerView((ViewGroup) view);
      }
    }

    return null;
  }

  public void setOnDefpageClickListener(DefaultEmptyPage.OnDefpageClickListener onDefpageClickListener) {
    this.onDefpageClickListener = onDefpageClickListener;
  }


  private String getString(int id){
    return mContext.getString(id);
  }
}
