package com.kangxin.common.http.entity;

import java.io.Serializable;

/**
 * Created by lihaipeng on 16/12/30.
 * 请求网络返回的信息
 */
public class NetResponseMessage<T> implements Serializable {
    /**
     * 返回的详细信息，有可能为空
     */
    private T data;

    /**
     * 消息说明
     */
    private String message;

    /**
     * 结果码
     */
    private String resultCode;

    /**
     * eventbus发布后的标记码
     */
    private String mark;

    public NetResponseMessage() {
    }

    public NetResponseMessage(String resultCode) {
        this.resultCode = resultCode;
    }

    public NetResponseMessage(String message, String resultCode) {
        this.message = message;
        this.resultCode = resultCode;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getResultCode() {
        return resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getMark() {
        return mark;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }

    @Override
    public String toString() {
        return "NetResponseMessage{" +
                "data=" + data +
                ", message='" + message + '\'' +
                ", resultCode='" + resultCode + '\'' +
                ", mark='" + mark + '\'' +
                '}';
    }
}
