package com.kangxin.common.imageloader;


import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;

import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;

public interface ImageLoader {

    /**
     * 加载图片
     *
     * @param url
     */
    ImageLoader loadImage(String url);


    /**
     * 图片的加载样式
     *
     * @param transformation
     * @return
     */
    ImageLoader transform(Transformation<Bitmap> transformation);

    /**
     * @return
     */
    ImageLoader centerCrop();

    /**
     * 转换风格
     *
     * @param style @see Sytle
     * @return
     */
    ImageLoader bitmapTransform(int style);


    ImageLoader bitmapTransform(Transformation<Bitmap> transformation);


    /**
     * 图片占位图
     *
     * @param id
     * @return
     */
    ImageLoader placeholder(int id);


    /**
     * 图片占位图
     *
     * @param drawable
     * @return
     */
    ImageLoader placeholder(Drawable drawable);

    /**
     * 加载到哪里
     *
     * @param target
     */
    void into(ImageView target);


    /**
     * 图片加载错误的图片
     *
     * @param id
     * @return
     */
    ImageLoader err(int id);

    /**
     * 图片加载错误的图片
     *
     * @param drawable
     * @return
     */
    ImageLoader err(Drawable drawable);

    /**
     * 磁盘缓存策略
     *
     * @param diskCacheStrategy
     * @return
     */
    ImageLoader diskCacheStrategy(DiskCacheStrategy diskCacheStrategy);

    /**
     * 是否在内存中缓存
     *
     * @param isCache
     * @return
     */
    ImageLoader skipMemoryCache(boolean isCache);

    /**
     * 图片添加签名
     *
     * @param key
     * @return
     */
    ImageLoader sign(Key key);
}
