package com.kangxin.common.imageshow;

import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;

import com.kangxin.common.Pretty;

import java.util.List;

import cn.finalteam.galleryfinal.widget.zoonview.PhotoView;

public class PhotoViewAdapter extends PagerAdapter {

    List<String> urlList;

    public PhotoViewAdapter(List<String> urlList) {
        this.urlList = urlList;
    }


    @Override
    public int getCount() {
        return urlList.size();
    }

    @Override
    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }


    @NonNull
    @Override
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        PhotoView photoView = new PhotoView(container.getContext());
        photoView.setLayoutParams(new ViewPager.LayoutParams());
        Pretty.create().loadImage(urlList.get(position)).into(photoView);
        container.addView(photoView);
        return photoView;
    }

    @Override
    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        container.removeView((View) object);
    }

}
