package com.kangxin.common.util;

import android.content.Context;
import android.os.Environment;

import com.kangxin.common.R;

import java.io.File;
import java.io.IOException;

public class ByFileUtil {

    private static String defaultDir = StringsUtils.getString(R.string.commbyh__baiyihui);

    private static String byTestFile = "by_text_file";

    private static boolean isCanCreateFile = false;


    /**
     * 获取是否可以使用文件目录，如果不可以则使用缓存目录，如果正常则使用sd卡目录
     *
     * @param context
     * @return
     */
    public static File getCanUserFileDir(Context context) {

        //先判断是否存在该文件夹
        File externalStorageDirectory = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + defaultDir);
        if (!externalStorageDirectory.exists()) {
            externalStorageDirectory.mkdir();
        }

        //文件夹下面尝试创建文件
        File file = new File(externalStorageDirectory, byTestFile);
        if (!file.exists()) {
            try {
                boolean newFile = file.createNewFile();
                isCanCreateFile = isCanCreateFile;
            } catch (IOException e) {
                isCanCreateFile = false;
                e.printStackTrace();
            }
        }

        //如果有创建文件，则正常进行
        if (isCanCreateFile) {
            return Environment.getExternalStorageDirectory();
        } else {
            return context.getCacheDir();
        }


    }


}
