package com.kangxin.doctor.worktable.util;

import android.text.TextUtils;

import com.blankj.utilcode.util.SPUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SaveSearchUtils {

    public static final String OPERATORKEY = "seachContent";

    public static void save(String seachContent) {

        seachContent = seachContent.replace(",", "");

        if (TextUtils.isEmpty(seachContent))
            return;

        List<String> dataList = get();

        StringBuilder build = new StringBuilder();
        for (int i = 0; i < dataList.size(); i++) {
            build.append(dataList.get(i));
            build.append(",");
        }

        build.append(seachContent);
        SPUtils.getInstance().put(OPERATORKEY, build.toString());
    }

    public static List<String> get() {

        String content = SPUtils.getInstance().getString(OPERATORKEY);

        if (TextUtils.isEmpty(content))
            return new ArrayList<>();

        String[] args = content.split(",");
        List<String> searchList = new ArrayList<>(Arrays.asList(args));

        if (searchList.size() > 5)
            return searchList.subList(searchList.size() - 5, searchList.size());
        else return searchList;
    }

    public static void clear() {
        SPUtils.getInstance().put(OPERATORKEY, "");
    }

    public static void remove(int position) {
        List<String> dataList = get();
        Collections.reverse(dataList);
        if (dataList.get(position) == null)
            return;
        dataList.remove(position);
        Collections.reverse(dataList);
        StringBuilder build = new StringBuilder();
        for (int i = 0; i < dataList.size(); i++) {
            build.append(dataList.get(i));
            if (i != dataList.size() - 1)
                build.append(",");
        }

        SPUtils.getInstance().put(OPERATORKEY, build.toString());
    }

}
