package com.byh.module.onlineoutser.im.view;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;

import com.byh.module.onlineoutser.im.utils.UiUtil;

import java.util.ArrayList;
import java.util.List;

public class FuncPager extends LinearLayout {

    private ViewPager mPager;
    private SparseArray<FuncPanel> mViews;
    private ColorPointHintView mHintView;
    private FuncPanel.ItemClickListener mItemClickListener;

    public FuncPager(Context context) {
        this(context, null);
    }

    public FuncPager(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FuncPager(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        setVisibility(GONE);
        setOrientation(VERTICAL);
        setBackgroundColor(Color.parseColor("#F0F0F0"));
        mPager = new AdaptionPager(context);
        addView(mPager, new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
        mHintView = new ColorPointHintView(getContext(), Color.parseColor("#E3AC42"), Color.parseColor("#dddcdc"));
        LayoutParams params = new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        params.bottomMargin = UiUtil.INSTANCE.dpToPx(5);
        addView(mHintView, params);
        mPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                mHintView.setCurrent(position);
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
    }

    public void setData(List<FuncPanel.Item> datas) {
        List<List<FuncPanel.Item>> pagerDatas = new ArrayList<>();
        int page = (int) Math.ceil(datas.size() / 8.0);
        for (int i = 0; i < page; i++) {
            List<FuncPanel.Item> items;
            if (i == page - 1) {
                items = datas.subList(i * 8, datas.size());
            } else {
                items = datas.subList(i * 8, (i + 1) * 8);
            }
            pagerDatas.add(items);
        }
        mPager.setAdapter(new MyAdapter(pagerDatas));
        if (pagerDatas.size() == 1) {
            mHintView.setVisibility(GONE);
        } else {
            mHintView.setVisibility(VISIBLE);
            mHintView.initView(pagerDatas.size(), 1);
        }
    }

    public void setItemClickListener(FuncPanel.ItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }

    public void show(Boolean show) {
        if (show) {
            setVisibility(View.VISIBLE);
        } else {
            setVisibility(View.GONE);
        }
    }

    public boolean isShow() {
        return getVisibility() == VISIBLE;
    }

    private class MyAdapter extends PagerAdapter {

        private List<List<FuncPanel.Item>> datas;

        public MyAdapter(List<List<FuncPanel.Item>> datas) {
            this.datas = datas;
        }

        @Override
        public int getCount() {
            return datas.size();
        }

        @Override
        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        @Override
        public Object instantiateItem(ViewGroup container, int position) {
            if (mViews == null) {
                mViews = new SparseArray<>();
            }
            FuncPanel panel = mViews.get(position);
            if (panel == null) {
                panel = new FuncPanel(getContext());
                ViewGroup.LayoutParams params = new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                panel.setLayoutParams(params);
                panel.setOnItemClickListener(mItemClickListener);
                mViews.put(position, panel);
            }
            panel.setDatas(datas.get(position));
            container.addView(panel);
            return panel;
        }

        @Override
        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView(mViews.get(position));
        }
    }
}
