package com.ebaiyihui.module_bothreferral.decorate;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.kangxin.common.R;


public class TiStarView extends LinearLayout {

    private String title;
    private Boolean isStar;
    private TextView ts;
    private TextView t;

    public TiStarView(Context context) {
        super(context);
    }

    public TiStarView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public TiStarView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        @SuppressLint("Recycle")
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.TiStarView);
        title = typedArray.getString(R.styleable.TiStarView_titleName);
        isStar = typedArray.getBoolean(R.styleable.TiStarView_hasStar, false);
        typedArray.recycle();
        setGravity(Gravity.CENTER_VERTICAL);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();

        LayoutInflater.from(getContext()).inflate(R.layout.tistar_view_layout, this);

        t = findViewById(R.id.title);
        t.setText(title);

        ts = findViewById(R.id.star);

        if (isStar)
            ts.setVisibility(VISIBLE);
        else ts.setVisibility(INVISIBLE);

    }

    public TiStarView setIsStar(boolean isStar) {
        this.isStar = isStar;
        if (ts != null)
            if (isStar)
                ts.setVisibility(VISIBLE);
            else ts.setVisibility(INVISIBLE);
        return this;
    }

    public TiStarView setTitle(String titleStr) {
        this.title = titleStr;
        if (t != null)
            t.setText(titleStr);
        return this;
    }

}
