package com.kangxin.common.byh.base;


import android.os.Bundle;
import android.view.View;

import androidx.annotation.NonNull;

import com.kangxin.common.byh.callback.EmptyCallback;
import com.kangxin.common.byh.callback.ErrorCallback;
import com.kingja.loadsir.callback.Callback;
import com.kingja.loadsir.core.LoadService;
import com.kingja.loadsir.core.LoadSir;

import org.jetbrains.annotations.Nullable;

import java.util.List;

public abstract class ByBaseStateTitleFlushMoreFragment<T> extends BaseFlushMoreFragment<T> {


    private LoadService loadService;


    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        View contentView = rootView.findViewById(showContentLayout());
        loadService = LoadSir.getDefault().register(contentView, new Callback.OnReloadListener() {
            @Override
            public void onReload(View v) {
                flushOrLoad(false);
            }
        });
    }

    @Override
    public void addMore(List<T> pageData) {
        super.addMore(pageData);
        loadService.showSuccess();
    }

    @Override
    public void bindData(List<T> pageData) {
        super.bindData(pageData);
        loadService.showSuccess();
    }

    @Override
    public void noData() {
        super.noData();
        loadService.showCallback(EmptyCallback.class);
    }

    @Override
    public void error() {
        super.error();
        loadService.showCallback(ErrorCallback.class);
    }

    @Override
    public void error(@Nullable String errorMsg) {
        super.error(errorMsg);
        loadService.showCallback(ErrorCallback.class);
    }

    public abstract int showContentLayout();

}
