package com.kangxin.common.byh.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.DrawableRes;

import com.kangxin.common.R;


public class ClickNextItem extends RelativeLayout {
    private TextView mLabelNameView;
    private TextView mValueView;
    private ImageView mArrowView;

    private View mRightView;
    private ImageView mLeftIconView;

    public ClickNextItem(Context context) {
        this(context, null);
    }

    public ClickNextItem(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ClickNextItem(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View rootView = LayoutInflater.from(context).inflate(R.layout.commbyh_click_next_item, this, false);
        addView(rootView);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ClickNextItem);
        String labelName = null;
        String value = null;
        int labelColor = Color.parseColor("#666666");
        int valueColor = Color.parseColor("#333333");
        boolean isShowArrow = true;
        int leftIcon = -1;
        if (typedArray != null) {
            labelName = typedArray.getString(R.styleable.ClickNextItem_label_name);
            value = typedArray.getString(R.styleable.ClickNextItem_value);
            isShowArrow = typedArray.getBoolean(R.styleable.ClickNextItem_isShowArrow, true);
            labelColor = typedArray.getColor(R.styleable.ClickNextItem_label_color_nextitem, Color.parseColor("#666666"));
            valueColor = typedArray.getColor(R.styleable.ClickNextItem_value_color_nextitem, Color.parseColor("#333333"));
            leftIcon = typedArray.getResourceId(R.styleable.ClickNextItem_lefticon_nextitem, -1);
            typedArray.recycle();
        }

        mLabelNameView = findViewById(R.id.label_name_txt);
        mValueView = findViewById(R.id.value_name);
        mArrowView = findViewById(R.id.right_arrow_img);
        mRightView = findViewById(R.id.value_layout);
        mLeftIconView = findViewById(R.id.left_icon);


        mLabelNameView.setTextColor(labelColor);
        mValueView.setTextColor(valueColor);

        if (leftIcon != -1) {
            mLeftIconView.setVisibility(View.VISIBLE);
            mLeftIconView.setImageResource(leftIcon);
        }
        if (!TextUtils.isEmpty(labelName)) {
            mLabelNameView.setText(labelName);
        }


        if (!TextUtils.isEmpty(value)) {
            mValueView.setText(value);
        }

        if (isShowArrow) {
            mArrowView.setVisibility(View.VISIBLE);
        } else {
            mArrowView.setVisibility(View.GONE);
        }

    }

    public void setOnRightValueListener(View.OnClickListener listener) {
        if (mRightView != null) {
            mRightView.setOnClickListener(listener);
        }
    }

    public void setLabelName(String labelName) {
        if (mLabelNameView != null) {
            mLabelNameView.setText(labelName);
        }
    }


    public void setArrowImg(@DrawableRes int resId) {
        if (mArrowView != null) {
            mArrowView.setImageResource(resId);
        }
    }


    public void setValue(String value) {
        if (mValueView != null) {
            mValueView.setText(value);
        }
    }


    public void setShowArrow(boolean isShow) {
        if (isShow) {
            mArrowView.setVisibility(View.VISIBLE);
        } else {
            mArrowView.setVisibility(View.GONE);
        }
    }
}
