package com.kangxin.common.byh.widget;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.DrawableRes;

import com.kangxin.common.R;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;

import java.util.List;

public class DefaultEmptyPage {

  private ViewGroup mBusViewGroup;
  private View mDefView;

  public void showDef(boolean isShow){

    if(isShow){
      mDefView.setVisibility(View.VISIBLE);
      mBusViewGroup.setVisibility(View.GONE);
    }else {
      mDefView.setVisibility(View.GONE);
      mBusViewGroup.setVisibility(View.VISIBLE);
    }
  }


  public interface OnDefpageClickListener{
    void onClickDefbtn(View view);
  }

  public static class Builder<T>{

    private ViewGroup mBusViewGroup;
    @DrawableRes
    private int mImgId;
    private String mBtnText;
    private String mDefDescText;
    private String mDefDescEnglishText;

    private Context mContext;
    private OnDefpageClickListener onDefpageClickListener;
    private List<T>  mDataList;

    public Builder(Context context) {
      this.mContext = context;
    }


    public Builder setDefDescText(String text){
      mDefDescText = text;
      return this;
    }

    public Builder setDefEngText(String engText){
      mDefDescEnglishText = engText;
      return this;
    }

    public Builder setDataList(List<T> dataList){
      mDataList = dataList;
      return this;
    }

    public Builder setBusViewGroup(ViewGroup viewGroup){
      mBusViewGroup = viewGroup;
      return this;
    }

    public Builder setDefImgid(@DrawableRes int imgId){
      mImgId = imgId;
      return this;
    }

    public Builder setDefBtnText(String btnText){
      mBtnText = btnText;
      return this;
    }


    public Builder setOnDefpageClickListener(OnDefpageClickListener onDefpageClickListener){
      this.onDefpageClickListener = onDefpageClickListener;
      return this;
    }


    public DefaultEmptyPage create(){
      DefaultEmptyPage defaultEmptyPage = new DefaultEmptyPage();
      defaultEmptyPage.mBusViewGroup = this.mBusViewGroup;
      View defView = View.inflate(mContext, R.layout.commbyh_list_empty_place2, null);
      defaultEmptyPage.mDefView = defView;

      //////////////init views of defview//////////

      ImageView placeImgView = defView.findViewById(R.id.place_img);

      if(mImgId != 0){
        placeImgView.setImageResource(mImgId);
      }

      TextView defDescView = defView.findViewById(R.id.place_seat_desc);
      if(!TextUtils.isEmpty(mDefDescText)){
        defDescView.setText(mDefDescText);
      }
      TextView defDescView2 = defView.findViewById(R.id.place_seat_desc2);
      if(!TextUtils.isEmpty(mDefDescEnglishText)){
        defDescView2.setText(mDefDescEnglishText);
      }

      TextView defBtn = defView.findViewById(R.id.def_page_btn);
      if(!TextUtils.isEmpty(mBtnText)){
        defBtn.setText(mBtnText);
      }
      defBtn.setOnClickListener(new View.OnClickListener() {
        @Override
        public void onClick(View v) {
          //click defview btn
          if(onDefpageClickListener != null){
            onDefpageClickListener.onClickDefbtn(v);
          }
        }
      });

      ////////////////////////////////////

      ViewParent parent = mBusViewGroup.getParent();
      ViewGroup parentGroupView = null;
      if(parent instanceof ViewGroup){
        parentGroupView = (ViewGroup) parent;
      }

      if(mDataList != null && mDataList.size() > 0){
        mBusViewGroup.setVisibility(View.VISIBLE);
        defView.setVisibility(View.GONE);
      }else {
        mBusViewGroup.setVisibility(View.GONE);
        defView.setVisibility(View.VISIBLE);
      }

      if(parentGroupView != null && !hasDefView(parentGroupView, defView)){
        if(parentGroupView instanceof SmartRefreshLayout){
          throw new RuntimeException("SmartRefreshLayout must have only a child view, please add a only view!!!");
        }

        parentGroupView.addView(defView);
      }

      return defaultEmptyPage;
    }

    private boolean hasDefView(ViewGroup viewGroup, View defViewGroup){
      int childCount = viewGroup.getChildCount();
      for (int i = 0; i < childCount; i++) {
        View childView = viewGroup.getChildAt(i);
        if(childView == defViewGroup){
          return true;
        }
      }

      return false;
    }

  }

}
