package com.kangxin.common.byh.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.R;

import java.util.List;

public class TwoLinkageListView extends RelativeLayout {

    private static RecyclerView mLeftCyclerView;
    private static RecyclerView mRightCyclerView;
    private static Context mContext;
    private BaseLinkageAdapter mLinkageListAdapter;

    public TwoLinkageListView(Context context) {
        this(context, null);
    }

    public TwoLinkageListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TwoLinkageListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mContext = context;
        LayoutInflater.from(context).inflate(R.layout.keshi_fragment, this);
        mLeftCyclerView = findViewById(R.id.left_list);
        mLeftCyclerView.setLayoutManager(new LinearLayoutManager(context));
        mRightCyclerView = findViewById(R.id.right_list);
        mRightCyclerView.setLayoutManager(new LinearLayoutManager(context));
    }

    public void setLinkageListAdapter(BaseLinkageAdapter linkageListAdapter) {
        mLinkageListAdapter = linkageListAdapter;
        mLinkageListAdapter.bindDataToView();
    }

    /**
     * 二级联动的基类adapter
     *
     * @param <LEFT>  左侧列表的实体泛型
     * @param <RIGHT> 右侧列表的实体泛型
     */
    public static abstract class BaseLinkageAdapter<LEFT, RIGHT> {

        /**
         * 是否默认显示二级列表
         */
        private boolean isDefShow;
        private View mPreItemView;


        private List<LEFT> mLeftDatas;
        private BaseQuickAdapter.OnItemClickListener linkItemClickListener;

        public BaseLinkageAdapter(List<LEFT> mLeftDatas, boolean isDefShow) {
            this.mLeftDatas = mLeftDatas;
            this.isDefShow = isDefShow;

        }

        /**
         * 设置点击二级列表的点击事件
         *
         * @param onItemClickListener
         */
        public void setOnItemClickListener(BaseQuickAdapter.OnItemClickListener onItemClickListener) {
            this.linkItemClickListener = onItemClickListener;
        }

        /**
         * 绑定数据到一级，二级列表上
         */
        private void bindDataToView() {
            BaseQuickAdapter leftQuickAdapter = new BaseQuickAdapter<LEFT, BaseViewHolder>(getLeftLayoutId(), mLeftDatas) {
                @Override
                protected void convert(BaseViewHolder helper, LEFT item) {
                    leftConvert(helper, item);
                }

                @Override
                public void onBindViewHolder(BaseViewHolder holder, int position) {
                    super.onBindViewHolder(holder, position);

                    if (isDefShow) {
                        if (position == 0) {
                            holder.itemView.setBackgroundColor(mContext.getResources().getColor(android.R.color.white));
                            mPreItemView = holder.itemView;
                        }
                    }

                }
            };

            leftQuickAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
                @Override
                public void onItemClick(BaseQuickAdapter adapter, View view, int position) {

                    if (mPreItemView != null) {
                        mPreItemView.setBackgroundColor(mContext.getResources()
                                .getColor(R.color.gray_f7f8f7));
                    }

                    view.setBackgroundColor(mContext.getResources().getColor(R.color.white));
                    mPreItemView = view;

                    LEFT item = mLeftDatas.get(position);
                    setRightAdapter(getSubList(item));

                }
            });

            mLeftCyclerView.setAdapter(leftQuickAdapter);

            if (isDefShow) {
                if (mLeftDatas != null && mLeftDatas.size() > 0) {
                    List<RIGHT> rightList = getSubList(mLeftDatas.get(0));
                    if (rightList != null && rightList.size() > 0) {
                        setRightAdapter(rightList);
                    }
                }
            }

        }

        /**
         * 设置右侧列表的adapter
         *
         * @param rightList
         */
        private void setRightAdapter(List<RIGHT> rightList) {
            BaseQuickAdapter rightQuickAdapter = new BaseQuickAdapter<RIGHT, BaseViewHolder>(getRightLayoutId(), rightList) {

                @Override
                protected void convert(BaseViewHolder helper, RIGHT item) {
                    rightConvert(helper, item);
                }
            };
            rightQuickAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
                @Override
                public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                    if (linkItemClickListener != null) {
                        linkItemClickListener.onItemClick(adapter, view, position);
                    }
                }
            });

            mRightCyclerView.setAdapter(rightQuickAdapter);

        }

        /**
         * 获取二级列表
         *
         * @param leftEntity
         * @return
         */
        public abstract List<RIGHT> getSubList(LEFT leftEntity);

        /**
         * 得到左侧的布局
         *
         * @return
         */
        public abstract int getLeftLayoutId();

        /**
         * 得到右侧的布局
         *
         * @return
         */
        public abstract int getRightLayoutId();

        /**
         * 左侧的数据绑定
         *
         * @param helper
         * @param item
         */
        public abstract void leftConvert(BaseViewHolder helper, LEFT item);

        /**
         * 右侧的数据绑定
         *
         * @param helper
         * @param item
         */
        public abstract void rightConvert(BaseViewHolder helper, RIGHT item);

    }


}
