package com.kangxin.common.widget;

import android.util.Log;
import android.view.ViewGroup;

import java.util.ArrayList;
import java.util.List;

public class RecyclerViewCache {

    private static final String TAG = "RecyclerViewCache";
    private List<ViewGroup> mViewList = new ArrayList<>();

    private static RecyclerViewCache INSTANCE = new RecyclerViewCache();
    private RecyclerViewCache() {
    }

    public static RecyclerViewCache getInstance(){
        if(INSTANCE == null){
            INSTANCE = new RecyclerViewCache();
        }

        return INSTANCE;
    }

    public void putView(ViewGroup viewGroup){
        Log.i(TAG, "putView: " + viewGroup);
        if(viewGroup == null){
            return;
        }
        mViewList.add(viewGroup);
    }

    public void removeView(ViewGroup viewGroup){
        Log.i(TAG, "removeView: " + viewGroup);
        if(viewGroup == null){
            return;
        }
        mViewList.remove(viewGroup);
    }

    public ViewGroup getRecyclerView(){
        Log.i(TAG, "getRecyclerView: list size:" + mViewList.size());
        if(mViewList.size() > 0){
            return mViewList.get(mViewList.size() - 1);
        }

        return null;
    }
}
