package com.kangxin.common.widget;

import android.accounts.NetworkErrorException;
import android.text.TextUtils;
import android.view.ViewGroup;

import com.blankj.utilcode.util.ToastUtils;
import com.blankj.utilcode.util.Utils;
import com.google.gson.JsonParseException;
import com.kangxin.common.R;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.widget.DefEmptyPageProxy;
import com.kangxin.common.util.StringsUtils;

import java.net.UnknownHostException;

import io.reactivex.observers.DefaultObserver;
import retrofit2.HttpException;

import static com.kangxin.common.http.HttpResCode.REQ_OK;

public abstract class RxBaseObserver<T> extends DefaultObserver<T> {

    @Override
    public void onError(Throwable e) {
        e.printStackTrace();
        ViewGroup viewGroup = RecyclerViewCache.getInstance().getRecyclerView();
        if(viewGroup != null){
            DefEmptyPageProxy.getInstance(Utils.getApp()).createDefEmptyPage(viewGroup,
                    DefEmptyPageProxy.DefEmptyType.NET_EXCEPTION);
        }

    }

    @Override
    public void onNext(T t) {

        if (t instanceof ResponseBody) {
            ResponseBody responseBody = (ResponseBody) t;
            if (responseBody.getCode() != REQ_OK) {
                onReqErr(responseBody.getCode(), responseBody.getMsg(),
                        responseBody.getErrCode());
                return;
            }
        }

        if (t instanceof UnknownHostException) {
            ToastUtils.showShort(StringsUtils.getString(R.string.common_qingjianchawangluolianjieshifoukeyong));
            return;
        } else if (t instanceof NetworkErrorException || t instanceof HttpException) {
            ToastUtils.showShort(StringsUtils.getString(R.string.common_wangluofangwencuowu));
            return;
        } else if (t instanceof JsonParseException) {
            return;
        } else if (t instanceof NullPointerException) {
            ToastUtils.showShort(t + "");
            return;
        } else if (t instanceof ArrayIndexOutOfBoundsException) {
            ToastUtils.showShort(t + "");
            return;
        }

        onReqNext(t);
    }

    public abstract void onReqNext(T t);

    public void onReqErr(Throwable e) {
    }

    public void onReqErr(int code, String msg, String errCode) {
        ViewGroup viewGroup = RecyclerViewCache.getInstance().getRecyclerView();
        if(viewGroup != null){
            DefEmptyPageProxy.getInstance(Utils.getApp()).createDefEmptyPage(viewGroup,
                    DefEmptyPageProxy.DefEmptyType.NET_EXCEPTION);
        }
        if (!TextUtils.isEmpty(msg)) {
            ToastUtils.showLong(msg);
        }
    }
}
