package com.kangxin.doctor.worktable.dialog;

import android.content.Context;
import android.view.View;

import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;

public class CenterHintDialog {


    private Context mContext;
    private String title;
    private String rightText = StringsUtils.getString(R.string.worktab_quxiazai);
    private String leftText = StringsUtils.getString(R.string.worktab_quxiao);
    private String message;
    private View.OnClickListener clickCancel;
    private View.OnClickListener clickOk;

    private Boolean touchOutCancel = true;

    private boolean isShowCancel = true;

    CenterHintDialog(Context mContext) {
        this.mContext = mContext;
    }

    public static CenterHintDialog with(Context mContext) {
        return new CenterHintDialog(mContext);
    }

    public CenterHintDialog setTitle(String title) {
        this.title = title;
        return this;
    }

    public CenterHintDialog setRightText(String rightText) {
        this.rightText = rightText;
        return this;
    }

    public CenterHintDialog setMesssage(String message) {
        this.message = message;
        return this;
    }

    public CenterHintDialog bindCancelClick(View.OnClickListener onClickListener) {
        this.clickCancel = onClickListener;
        return this;
    }

    public CenterHintDialog bindOkClick(View.OnClickListener onClickListener) {
        this.clickOk = onClickListener;
        return this;
    }

    public CenterHintDialog setShowCancel(boolean isShowCancel) {
        this.isShowCancel = isShowCancel;
        return this;
    }

    public CenterHintDialog setLeftText(String leftText) {
        this.leftText = leftText;
        return this;
    }


    public CenterHintDialog touchOutCancel(boolean isTouchCancel) {
        this.touchOutCancel = isTouchCancel;
        return this;
    }


    public void show() {

        new CenterHintDialogSpe(mContext)
                .bindLeftClick(clickCancel)
                .bindRightClick(clickOk)
                .setTouchOutCancel(touchOutCancel)
                .setShowCancel(isShowCancel)
                .setMessage(message)
                .setLeftText(leftText)
                .setTitle(title)
                .setRightText(rightText)
                .show();

    }

}
