package com.kangxin.doctor.worktable.dialog;

import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import com.kangxin.common.R;
import com.kangxin.common.byh.inter.Runnable;

import per.goweii.anylayer.AnyLayer;
import per.goweii.anylayer.Layer;

public class SaveStackDialog {

    Context mContext;

    Runnable<String> valueBack;

    private SaveStackDialog(Context mContext) {
        this.mContext = mContext;
    }

    public static SaveStackDialog with(Context mContext) {
        return new SaveStackDialog(mContext);
    }

    public SaveStackDialog bindBack(Runnable<String> valueBack) {
        this.valueBack = valueBack;
        return this;
    }

    public void show() {

        AnyLayer.dialog(mContext)
                .contentView(R.layout.save_stack_dialog_layout)
                .backgroundDimAmount(0.5f)
                .bindData(new Layer.DataBinder() {
                    @Override
                    public void bindData(Layer layer) {
                        TextView save = layer.getView(R.id.save);
                        EditText input = layer.getView(R.id.input);

                        save.setEnabled(false);
                        input.addTextChangedListener(new TextWatcher() {
                            @Override
                            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

                            }

                            @Override
                            public void onTextChanged(CharSequence s, int start, int before, int count) {

                                if (TextUtils.isEmpty(input.getText()))
                                    save.setEnabled(false);
                                else save.setEnabled(true);

                            }

                            @Override
                            public void afterTextChanged(Editable s) {

                            }
                        });
                    }
                })
                .onClick(new Layer.OnClickListener() {
                    @Override
                    public void onClick(Layer layer, View v) {
                        layer.dismiss();
                    }
                }, R.id.cancel)
                .onClick(new Layer.OnClickListener() {
                    @Override
                    public void onClick(Layer layer, View v) {
                        EditText input = layer.getView(R.id.input);
                        if (valueBack != null)
                            valueBack.runnable(input.getText().toString());
                        layer.dismiss();
                    }
                }, R.id.save)
                .show();

    }

}
